import Vue from "vue";
import Vuex from "vuex";
const { getVersion } = require("@/server/utils/store");
Vue.use(Vuex);
const defaultSetting = {
  gridShow: 1,
  language: "cn",
  gridValue: 0,
  autoPrint: false,
  gridSpacing: "10mm",
};
export default new Vuex.Store({
  state: {
    actionList: [],
    countryList: [],
    imgList: [],
    productDetail: {},
    windowWH: { width: 0, height: 0 },
    desktopDevice: 1, //1是兄弟，2是其他
    desktoVersion: getVersion() || "print", //print2.0是2.0，print4.0是4.0 print600是600
    orderType: "GC", //GC是POD，CN是PODCN US是PODUS
    WHproportion: 1, //宽高比例
    defaultProportion: 1,
    isPreView: false,
    actionIndex: -1,

    systemSetting: {
      gridShow: 1,
      gridValue: 0,
      unit: "mm",
      language: "cn",
      autoPrint: false,
      gridSpacing: 10,
    },
    defaultGrid: [
      {
        label: "16×18",
        value: 1,
        row: 16,
        col: 18,
        h: 0,
        w: 0,
      },
      {
        label: "16×21",
        value: 0,
        row: 16,
        col: 21,
        h: 0,
        w: 0,
      },
      {
        label: "7×8",
        value: 4,
        row: 7,
        col: 8,
        h: 0,
        w: 0,
      },
      {
        label: "10×12",
        row: 10,
        value: 3,
        col: 12,
        h: 0,
        w: 0,
      },
      {
        label: "14×16",
        row: 14,
        value: 2,
        col: 16,
        h: 0,
        w: 0,
      },
    ],
    grid: [],
  },
  mutations: {
    setDefaultSetting(state) {
      state.systemSetting = JSON.parse(JSON.stringify(defaultSetting));
    },
    updateSystemSetting(state, f) {
      state.systemSetting[f.field] = f.value;
    },
    changeActionList(state, value) {
      state.actionList = value;
    },
    changeActionIndex(state, value) {
      state.actionIndex = value;
    },
    changeImgList(state, value) {
      state.imgList = value;
    },
    changeDesktopDevice(state, value) {
      state.desktopDevice = value;
    },
    changeDesktoVersion(state, value) {
      state.desktoVersion = value;
    },
    setProductDetail(state, value) {
      state.productDetail = value;
    },
    setWHproportion(state, value) {
      state.WHproportion = value;
    },
    setDefaultproportion(state, value) {
      state.defaultProportion = value;
    },
    setIsPreView(state, value) {
      state.isPreView = value;
    },
    setOrderType(state, value) {
      state.orderType = value;
    },
    setGrid(state) {
      state.grid.forEach((el) => {
        if (el.value == 0) {
          let proportion = state.WHproportion;
          if (state.defaultProportion == 1.5) {
            proportion = 1.4;
          } else if (state.defaultProportion == 1.7) {
            proportion = 1.4;
          }
          el.h = 630 * proportion;
          el.w = 480 * proportion;
        } else if (el.value == 1) {
          el.h = 540 * state.WHproportion;
          el.w = 480 * state.WHproportion;
        } else if (el.value == 2) {
          el.h = 480 * state.WHproportion;
          el.w = 420 * state.WHproportion;
        } else if (el.value == 3) {
          el.h = 360 * (state.WHproportion + 0.8);
          el.w = 300 * (state.WHproportion + 0.8);
        } else if (el.value == 4) {
          el.h = 240 * (state.WHproportion + 1.8);
          el.w = 210 * (state.WHproportion + 1.8);
        } else if (el.value == 5) {
          el.h = 720 * 1.2;
          el.w = 720 * 1.2;
        } else if (el.value == 6) {
          el.h = 660 * 1.4;
          el.w = 540 * 1.4;
        }
      });
    },
    setWindows(state, { width, height }) {
      state.windowWH = { width, height };
    },
    setCountry(state, data) {
      state.countryList = data;
    },
    getNewGrid(state) {
      if (state.desktoVersion == "print600") {
        state.grid = [
          ...state.defaultGrid.slice(0, 1),
          ...state.defaultGrid.slice(2),
          {
            label: "18×22",
            value: 6,
            row: 18,
            col: 22,
            h: 0,
            w: 0,
          },
          {
            label: "24×24",
            value: 5,
            row: 24,
            col: 24,
            h: 0,
            w: 0,
          },
        ];
      } else {
        state.grid = [...state.defaultGrid];
      }
    },
  },
  getters: {
    systemSetting(state) {
      return state.systemSetting;
    },
    getActionList(state) {
      return state.actionList;
    },
    getActionIndex: (state) => state.actionIndex,
    imgList: (state) => state.imgList,
  },
  actions: {},
  modules: {},
});
