import { exec } from "child_process";

var fs = require("fs");
var path = require("path");
var request = require("request");
var uuid = require("uuid");
const compressing = require("compressing");

const { getVersion } = require("@/server/utils/store");

function getCurrentVersion() {
  const version = getVersion();
  console.log("version", version);

  return version;
}

function zip(from, to) {
  return new Promise((resolve, reject) => {
    let dirName = path.join(to, uuid.v4());
    console.log(dirName);
    if (!fs.existsSync(dirName)) {
      fs.mkdirSync(dirName);
    }
    let arr = [];
    compressing.zip
      .uncompress(from, dirName, { zipFileNameEncoding: "gbk" })
      .then(() => {
        console.log("success");
        let data = fs.readdirSync(dirName);
        for (let i = 0; i < data.length; i++) {
          let fileName = uuid.v4() + ".png";
          let el = data[i];
          let file_path = path.join(dirName, el);
          console.log(file_path, to);
          fs.renameSync(file_path, path.join(to, fileName));
          arr.push({
            fileName: fileName,
            designId: data[i].split("_GCPS")[0],
            productionFile: path.join(to, fileName),
          });
        }

        fs.unlinkSync(from); // 删除压缩包
        fs.rmdirSync(dirName); // 删除目录文件
        // console.log(arr);
        resolve(arr);
      })
      .catch((err) => {
        console.log(err);
        reject("压缩包解压失败");
      });
  });
}

// // 下载素材
// export const downloadImage = (list) => {
//   return new Promise((resolve, reject) => {
//     try {
//       // console.log("Formatted Folder Name:", folderName); // 检查替换结果
//       let dirPath = path.join(process.cwd(), `./${getCurrentVersion()}/Input/`);
//       console.log(62, dirPath);
//       console.log("list", list);

//       if (!fs.existsSync(dirPath)) {
//         fs.mkdirSync(dirPath);
//       }

//       let count = 0;
//       for (let i = 0; i < list.length; i++) {
//         if (list[i].url && list[i].url.includes("http")) {
//           let fileName = "";
//           let type = 2;
//           let flag =
//             [
//               ".zip",
//               ".gzip",
//               ".tar",
//               ".taz",
//               ".rar",
//               ".7z",
//               ".gz",
//               ".bz2",
//             ].filter((el) => list[i].url.toLowerCase().includes(el)).length > 0;
//           if (flag) {
//             fileName = list[i].url.split("/")[
//               list[i].url.split("/").length - 1
//             ];
//             type = 1;
//           } else {
//             fileName = uuid.v4() + ".png";
//             type = 2;
//           }
//           let p = path.join(
//             process.cwd(),
//             `./${getCurrentVersion()}/Input/` + fileName
//           );
//           let stream = fs.createWriteStream(p);
//           request(list[i].url)
//             .pipe(stream)
//             .on("close", async function() {
//               if (type === 1) {
//                 list[i].list = await zip(p, dirPath);
//                 if (count === list.length - 1) {
//                   resolve(list);
//                 }
//               } else {
//                 if (!list[i].list) list[i].list = [];
//                 const filename = list[i].url.split("/")[
//                   list[i].url.split("/").length - 1
//                 ];
//                 console.log(filename);

//                 list[i].list.push({
//                   fileName,
//                   productionFile: p,
//                   designId: filename.split("_GCPS")[0],
//                 });
//               }
//               if (count === list.length - 1) {
//                 // console.log(list);
//                 resolve(list);
//               }
//               count++;
//             });
//         }
//       }
//     } catch (err) {
//       console.log(err);
//       reject(err);
//     }
//   });
// };
export const downloadImage = (list) => {
  return new Promise(async (resolve, reject) => {
    try {
      const dirPath = path.join(
        process.cwd(),
        `./${getCurrentVersion()}/Input/`
      );

      // 创建目录（如果不存在）
      if (!fs.existsSync(dirPath)) {
        fs.mkdirSync(dirPath, { recursive: true });
      }

      // 过滤出有效的下载项
      const downloadItems = list.filter(
        (item) => item.url && item.url.includes("http")
      );

      // 如果没有需要下载的项，直接返回
      if (downloadItems.length === 0) {
        return resolve(list);
      }

      // 并行处理所有下载
      const downloadPromises = downloadItems.map((item) => {
        return new Promise(async (itemResolve) => {
          try {
            const archiveExtensions = [
              ".zip",
              ".gzip",
              ".tar",
              ".taz",
              ".rar",
              ".7z",
              ".gz",
              ".bz2",
            ];
            const isArchive = archiveExtensions.some((ext) =>
              item.url.toLowerCase().includes(ext)
            );

            const fileName = isArchive
              ? item.url.split("/").pop()
              : `${uuid.v4()}.png`;

            const filePath = path.join(dirPath, fileName);

            // 使用流下载文件
            const writeStream = fs.createWriteStream(filePath);
            const requestStream = request(item.url);

            // 添加超时处理
            requestStream.on("response", (response) => {
              response.setTimeout(30000, () => {
                requestStream.abort();
                console.error(`下载超时: ${item.url}`);
                itemResolve();
              });
            });

            // 使用管道连接请求流和写入流
            requestStream.pipe(writeStream);

            // 等待下载完成
            await new Promise((resolveStream) => {
              writeStream.on("finish", resolveStream);
              writeStream.on("error", (err) => {
                console.error(`下载失败: ${item.url}`, err);
                resolveStream();
              });
            });

            if (isArchive) {
              // 处理压缩文件
              item.list = await zip(filePath, dirPath);
            } else {
              // 处理普通图片文件
              if (!item.list) item.list = [];
              const originalName = item.url.split("/").pop();
              item.list.push({
                fileName,
                productionFile: filePath,
                designId: originalName.split("_GCPS")[0],
              });
            }
          } catch (error) {
            console.error(`处理失败: ${item.url}`, error);
          } finally {
            itemResolve();
          }
        });
      });

      // 等待所有下载完成
      await Promise.all(downloadPromises);
      resolve(list);
    } catch (err) {
      console.error("下载整体失败", err);
      reject(err);
    }
  });
};

export function downloadOtherImage(list) {
  return new Promise((resolve, reject) => {
    try {
      const currentDate = new Date();

      // 将 UTC 时间转换为中国时间 (UTC + 8小时)
      const chinaTimeOffset = 8 * 60 * 60 * 1000; // 8小时，单位是毫秒
      const chinaTime = new Date(currentDate.getTime() + chinaTimeOffset);

      // 将当前中国时间格式化为ISO字符串
      let isoString = chinaTime.toISOString();
      console.log("Original China Time ISO String:", isoString); // 检查格式

      // 替换掉时间中的 ':' 字符
      const folderName =
        isoString.split("T")[0] +
        "_" +
        isoString
          .split("T")[1]
          .replace(/:/g, "-")
          .split(".")[0];
      let otherTypePath = path.join(
        process.cwd(),
        `./${getCurrentVersion()}/Input/${folderName}`
      );
      if (!fs.existsSync(otherTypePath)) {
        fs.mkdirSync(otherTypePath);
      }

      let count = 0;
      for (let i = 0; i < list.length; i++) {
        if (list[i].url && list[i].url.includes("http")) {
          let fileName = "";
          let type = 2;
          let flag =
            [
              ".zip",
              ".gzip",
              ".tar",
              ".taz",
              ".rar",
              ".7z",
              ".gz",
              ".bz2",
            ].filter((el) => list[i].url.toLowerCase().includes(el)).length > 0;
          if (flag) {
            fileName = list[i].url.split("/")[
              list[i].url.split("/").length - 1
            ];
            type = 1;
          } else {
            fileName = uuid.v4() + ".png";
            type = 2;
          }
          let otherP = path.join(otherTypePath, fileName); // 保存到新文件夹
          let otherstream = fs.createWriteStream(otherP);
          request(list[i].url)
            .pipe(otherstream)
            .on("close", async function() {
              if (type === 1) {
                list[i].list = await zip(otherP, otherTypePath);
                if (count === list.length - 1) {
                  resolve(list);
                }
              } else {
                if (!list[i].list) list[i].list = [];
                const filename = list[i].url.split("/")[
                  list[i].url.split("/").length - 1
                ];
                list[i].list.push({
                  fileName,
                  productionFile: otherP,
                  designId: filename.split("_GCPS")[0],
                });
              }
              if (count === list.length - 1) {
                // console.log(list);
                resolve(list);
              }
              count++;
            });
        }
      }
    } catch (err) {
      console.log(err);
      reject(err);
    }
  });
}

// 传递素材给前端
export const sendImg = (filename = "sample.png") => {
  let filePath = path.join(
    process.cwd(),
    `./${getCurrentVersion()}/Input/` + filename
  );
  if (!fs.existsSync(filePath)) {
    return false;
  }
  let data = fs.readFileSync(filePath);
  data = Buffer.from(data).toString("base64");
  return "data:" + "png" + ";base64," + data;
};

export const toSend = (body) => {
  console.log("999999999", path.join(process.cwd(), getCurrentVersion()));

  return new Promise((resolve, reject) => {
    exec(
      body.cmd,
      { cwd: path.join(process.cwd(), getCurrentVersion()), shell: true },
      (err) => {
        // console.log(stdout, 1);
        // console.log(stderr, 2);
        console.log("err", err);

        if (!err) {
          exec(
            body.print_cmd,
            { cwd: path.join(process.cwd(), getCurrentVersion()), shell: true },
            (err2) => {
              console.log(err2);
              if (!err2) {
                // 成功后删除 素材图，xml，output文件
                // fs.unlinkSync(path.join(process.cwd(), 'print/Input/' + body.fileName))
                fs.unlinkSync(
                  path.join(
                    process.cwd(),
                    `${getCurrentVersion()}/Profile/` +
                      body.fileName.replace(".png", "") +
                      ".xml"
                  )
                );
                fs.unlinkSync(
                  path.join(
                    process.cwd(),
                    `${getCurrentVersion()}/Output/` +
                      body.fileName.replace(".png", "") +
                      ".arxp"
                  )
                );
                resolve("操作成功");
              } else {
                const errorDetails = `打印命令失败: ${err2.message}`;
                return reject(`打印机错误: ${errorDetails}`);
              }
            }
          );
        } else {
          // const errorCode = err.code || "UNKNOWN_ERROR";
          // const errorDetails = [
          //   `生成命令失败: ${body.cmd}`,
          //   `错误代码: ${errorCode}`,
          //   `错误信息: ${err.message}`,
          //   `标准错误输出: ${stderr}`,
          // ].join("\n");
          const errorDetails = "未匹配到对应版本的驱动，请检查驱动";
          return reject(errorDetails);
        }
      }
    );
  });
};

export const writeProfileXml = (b) => {
  console.log(b);

  try {
    let p = path.join(
      process.cwd(),
      `./${getCurrentVersion()}/Profile/${b.byInk}.xml`
    );
    let file = fs.readFileSync(p, { encoding: "utf8" });
    file = file.replace(
      /<uiCopies>(.*)<\/uiCopies>/i,
      `<uiCopies>${b.printNum}</uiCopies>`
    );
    file = file.replace(
      /<byPlatenSize>(.*)<\/byPlatenSize>/i,
      `<byPlatenSize>${b.byPlatenSize}</byPlatenSize>`
    );
    file = file.replace(
      /<bEcoMode>(.*)<\/bEcoMode>/i,
      `<bEcoMode>${b.bEcoMode}</bEcoMode>`
    );
    file = file.replace(
      /<bMaterialBlack>(.*)<\/bMaterialBlack>/i,
      `<bMaterialBlack>${b.bMaterialBlack}</bMaterialBlack>`
    );
    file = file.replace(
      /<byHighlight>(.*)<\/byHighlight>/i,
      `<byHighlight>${b.byHighlight}</byHighlight>`
    );
    file = file.replace(
      /<byMask>(.*)<\/byMask>/i,
      `<byMask>${b.byMask}</byMask>`
    );
    file = file.replace(
      /<bTransColor>(.*)<\/bTransColor>/i,
      `<bTransColor>${b.bTransColor}</bTransColor>`
    );
    file = file.replace(
      /<bPause>(.*)<\/bPause>/i,
      `<bPause>${b.bPause}</bPause>`
    );
    file = file.replace(
      /<bDivide>(.*)<\/bDivide>/i,
      `<bDivide>${b.bDivide}</bDivide>`
    );
    file = file.replace(
      /<byChoke>(.*)<\/byChoke>/i,
      `<byChoke>${b.byChoke}</byChoke>`
    );
    file = file.replace(/<byInk>(.*)<\/byInk>/i, `<byInk>${b.byInk}</byInk>`);
    file = file.replace(
      /<bFastMode>(.*)<\/bFastMode>/i,
      `<bFastMode>${b.bFastMode}</bFastMode>`
    );
    file = file.replace(
      /<byResolution>(.*)<\/byResolution>/i,
      `<byResolution>${1}</byResolution>`
    );
    file = file.replace(
      /<byInkVolume>(.*)<\/byInkVolume>/i,
      `<byInkVolume>${b.byInkVolume}</byInkVolume>`
    );
    file = file.replace(
      /<byDoublePrint>(.*)<\/byDoublePrint>/i,
      `<byDoublePrint>${b.byDoublePrint}</byDoublePrint>`
    );
    file = file.replace(
      /<bMultiple>(.*)<\/bMultiple>/i,
      `<bMultiple>${b.bMultiple}</bMultiple>`
    );
    file = file.replace(
      /<bySaturation>(.*)<\/bySaturation>/i,
      `<bySaturation>${b.bySaturation}</bySaturation>`
    );
    file = file.replace(
      /<byBrightness>(.*)<\/byBrightness>/i,
      `<byBrightness>${b.byBrightness}</byBrightness>`
    );
    file = file.replace(
      /<byContrast>(.*)<\/byContrast>/i,
      `<byContrast>${b.byContrast}</byContrast>`
    );
    file = file.replace(
      /<iCyanBalance>(.*)<\/iCyanBalance>/i,
      `<iCyanBalance>${b.iCyanBalance}</iCyanBalance>`
    );
    file = file.replace(
      /<iMagentaBalance>(.*)<\/iMagentaBalance>/i,
      `<iMagentaBalance>${b.iMagentaBalance}</iMagentaBalance>`
    );
    file = file.replace(
      /<iYellowBalance>(.*)<\/iYellowBalance>/i,
      `<iYellowBalance>${b.iYellowBalance}</iYellowBalance>`
    );
    file = file.replace(
      /<iBlackBalance>(.*)<\/iBlackBalance>/i,
      `<iBlackBalance>${b.iBlackBalance}</iBlackBalance>`
    );
    file = file.replace(
      /<bUniPrint>(.*)<\/bUniPrint>/i,
      `<bUniPrint>${b.bUniPrint}</bUniPrint>`
    );
    fs.writeFileSync(
      path.join(
        process.cwd(),
        `./${getCurrentVersion()}/Profile/${b.fileName.replace(".png", "")}.xml`
      ),
      file
    );
  } catch (err) {
    console.log(404, err);
  }
};
