import Vue from "vue";
import VueRouter from "vue-router";

Vue.use(VueRouter);

const routes = [
  {
    path: "/",
    name: "login",
    meta: {
      title: "登录",
    },
    component: (resolve) => require(["../views/login/index.vue"], resolve),
  },
  {
    path: "/design",
    name: "design",
    meta: {
      title: "设计页面",
    },
    component: (resolve) => require(["../views/design/index.vue"], resolve),
  },

  {
    path: "/design-detail",
    name: "design",
    meta: {
      title: "设计详情页面",
    },
    component: (resolve) =>
      require(["../views/design/detail/index.vue"], resolve),
  },
  {
    path: "*",
    redirect: "/",
  },
];

const router = new VueRouter({
  mode: "hash",
  base: process.env.BASE_URL,
  routes,
});
router.beforeEach((to, from, next) => {
  let user = Vue.prototype.$dataStore.get("user");
  if (to.path.includes("design-detail")) {
    return next();
  }

  if (to.name === "login") {
    if (user) {
      return next({ path: "/design" });
    } else {
      return next();
    }
  } else {
    if (user) {
      return next();
    } else {
      return next("/");
    }
  }
});
export default router;
