import Vue from "vue";
import Vuex from "vuex";

Vue.use(Vuex);
const defaultSetting = {
  gridShow: 1,
  language: "cn",
  gridValue: 0,
  autoPrint: false,
  gridSpacing: "10mm",
};
export default new Vuex.Store({
  state: {
    actionList: [],
    countryList: [],
    imgList: [],
    productDetail: {},
    windowWH: { width: 0, height: 0 },
    desktopDevice: 1, //1是兄弟，2是其他
    WHproportion: 1, //宽高比例
    defaultProportion: 1,
    isPreView: false,
    actionIndex: -1,
    systemSetting: {
      gridShow: 1,
      gridValue: 0,
      unit: "mm",
      language: "cn",
      autoPrint: false,
      gridSpacing: 10,
    },
    grid: [
      // {
      //   label: "7×8",
      //   value: 4,
      //   row: 7,
      //   col: 8,
      //   h: 0,
      //   w: 0,
      // },
      // {
      //   label: "10×12",
      //   row: 10,
      //   value: 3,
      //   col: 12,
      //   h: 0,
      //   w: 0,
      // },
      // {
      //   label: "14×16",
      //   row: 14,
      //   value: 2,
      //   col: 16,
      //   h: 0,
      //   w: 0,
      // },
      {
        label: "16×18",
        value: 1,
        row: 16,
        col: 18,
        h: 0,
        w: 0,
      },
      // {
      //   label: "16×21",
      //   value: 0,
      //   row: 16,
      //   col: 21,
      //   h: 0,
      //   w: 0,
      // },
    ],
  },
  mutations: {
    setDefaultSetting(state) {
      state.systemSetting = JSON.parse(JSON.stringify(defaultSetting));
    },
    updateSystemSetting(state, f) {
      state.systemSetting[f.field] = f.value;
    },
    changeActionList(state, value) {
      state.actionList = value;
    },
    changeActionIndex(state, value) {
      state.actionIndex = value;
    },
    changeImgList(state, value) {
      state.imgList = value;
    },
    changeDesktopDevice(state, value) {
      state.desktopDevice = value;
    },
    setProductDetail(state, value) {
      state.productDetail = value;
    },
    setWHproportion(state, value) {
      state.WHproportion = value;
    },
    setDefaultproportion(state, value) {
      state.defaultProportion = value;
    },
    setIsPreView(state, value) {
      state.isPreView = value;
    },
    setGrid(state) {
      // state.grid[0].h = h;
      // state.grid[0].w = w;
      state.grid.forEach((el) => {
        if (el.value == 0) {
          el.h = 630 * (state.WHproportion - 0.3);
          el.w = 480 * (state.WHproportion - 0.3);
        } else if (el.value == 1) {
          el.h = 540 * state.WHproportion;
          el.w = 480 * state.WHproportion;
        } else if (el.value == 2) {
          el.h = 480 * state.WHproportion;
          el.w = 420 * state.WHproportion;
        } else if (el.value == 3) {
          el.h = 360 * (state.WHproportion + 1);
          el.w = 300 * (state.WHproportion + 1);
        } else if (el.value == 4) {
          el.h = 240 * (state.WHproportion + 1.8);
          el.w = 210 * (state.WHproportion + 1.8);
        }
      });
    },
    setWindows(state, { width, height }) {
      state.windowWH = { width, height };
    },
    setCountry(state, data) {
      state.countryList = data;
    },
  },
  getters: {
    systemSetting(state) {
      return state.systemSetting;
    },
    getActionList(state) {
      return state.actionList;
    },
    getActionIndex: (state) => state.actionIndex,
    imgList: (state) => state.imgList,
  },
  actions: {},
  modules: {},
});
