import express from "express";

import fn from "../entity/function.js";

let router = express.Router();

// 执行打印命令
router.post("/toPrint", fn.toPrint);
// 打印日志添加
router.post("/writePrintLog", fn.writePrintLog);
// 登录接口
router.post("/login", fn.login);
// 获取本地文件返回
router.post("/getPngImg", fn.getPngImg);
// 上传文件到本地
router.post("/uploadImage", fn.uploadImage);
// 获取公司列表
router.get("/getCompanyList", fn.getCompanyList);
// 提交授权申请
router.post("/commitApply", fn.commitApply);
// 下载素材到本地
router.post("/downloadByDesignId", fn.downloadByDesignId);
// 获取 生产单号返回素材地址
router.post("/downloadBySubOrderNumber", fn.downloadBySubOrderNumber);
// 提交生产完成
router.post("/completeDelivery", fn.completeDelivery);
// 根据生产单号查询详情
router.post("/findByPodProductionNo", fn.findByPodProductionNo);
// 查询版本更新
router.get("/checkUpdate", fn.checkUpdate);
// 增量更新
router.post("/incrementalUpdates", fn.incrementalUpdates);
// 裁切单个图片的透明白边
router.post("/imageTransparentEdges", fn.imageTransparentEdges);
// 裁切图片目录中的所有图片的透明白边
router.post("/imageListTransparentEdges", fn.imageListTransparentEdges);
// 处理图片并输出结果
router.post("/processImage", fn.processImage);

// 保存生成后得图片返回地址
router.post("/saveToPng", fn.saveToPng);
// 保存生成后得图片返回地址
router.post("/getAllCountry", fn.getAllCountry);

//根据图片地址保存文件到本地
router.post("/saveImgByUrl", fn.saveImgByUrl);

export { router as default };
