import Vue from "vue";
import App from "./App.vue";
import router from "./router";
import store from "./store";
import VueI18n from "vue-i18n";
import VueCompositionApi from "@vue/composition-api";
import { Message } from "element-ui";
// 挂载到$message上
import api from "@/utils/axios";
import ElementUI from "element-ui";
import "element-ui/lib/theme-chalk/index.css";
import dataStore from "electron-store";

const DataStore = new dataStore();

Vue.config.productionTip = false;
Vue.use(ElementUI);
Vue.use(VueCompositionApi);

Vue.use(VueI18n);
Vue.prototype.$message = Message;
Vue.prototype.$dataStore = DataStore;
Vue.prototype.$store = store;
Vue.prototype.$api = api;
Vue.prototype.$message = Message;
const i18n = new VueI18n({
  locale: "zh",
  messages: {
    zh: require("./i18n/zh.js"),
    en: require("./i18n/en.js")
  }
});

new Vue({
  router,
  store,
  i18n,
  render: h => h(App)
}).$mount("#app");
