import express from "express";
import router from "./routes/index.js";
import { logMiddleWare } from "./utils/log";
const PORT = 3000;
// const printPORT = 3030;
// // 获取应用程序的安装目录
// let exePath = path.dirname(app.getPath("exe"));

export const createServer = () => {
  const webApp = express();
  // const printApp = express();
  //webApp.use(logger("./logs"));
  webApp.use(logMiddleWare());
  webApp.use(express.json());
  webApp.use(express.urlencoded({ extended: false }));
  webApp.use("/", router); 
  // catch 404
  webApp.use((req, res) => {
    res.status(404).send("Sorry! 404 Error.");
  });

  // error handler, 4个参数
  webApp.use((err, req, res) => {
    // set locals, only providing error in development
    res.locals.message = err.message;
    res.locals.error = req.app.get("env") === "development" ? err : {};

    // render the error page
    res.status(err.status || 500);
    res.json({
      message: err.message,
      error: err,
    });
  });

  webApp.set("port", PORT);

  webApp.listen(PORT, () => console.log(`App listening on port ${PORT}`));

  // if (process.env.NODE_ENV === "development") {
  //   printApp.use(express.static(path.join(__dirname, "..", "print", "input")));
  // } else {
  //   printApp.use(express.static(path.join(exePath, "print", "input")));
  // }
  // // printApp 的 404 错误处理
  // printApp.use((req, res) => {
  //   res.status(404).send("Sorry! 404 Error.");
  // });
  // // printApp 错误处理中间件
  // printApp.use((err, req, res) => {
  //   res.locals.message = err.message;
  //   res.locals.error = req.app.get("env") === "development" ? err : {};
  //   res.status(err.status || 500);
  //   res.json({
  //     message: err.message,
  //     error: err,
  //   });
  // });
  // // 启动服务器
  // printApp.listen(printPORT, () => {
  //   console.log(`Express server running at http://localhost:${printPORT}`);
  // });
};
