<script setup>
import { ref, defineProps } from 'vue';
const props = defineProps(['src']);

const popupImage = ref(null);
const open = () => {
    popupImage.value.style.display = 'block';
};

const close = () => {
    popupImage.value.style.display = 'none';
}

</script>

<img class="original-image" :src="props.src" @click="open()">

<div class="popup-image" ref="popupImage" @click="close">
    <img :src="props.src" @click="$event.stopPropagation()" />
</div>

<style>
.original-image {
    margin-bottom: 20px;
    cursor: pointer;
}
.popup-image {
    position: fixed;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.6);
    top: 0;
    left: 0;
    z-index: 30;
    display: none;
}
.popup-image img {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    max-width: 90%;
    max-height: 90%;
    width: 85%;
}

@media (max-width: 640px) {
    .popup-image img {
        max-width: 99%;
        width: 100%;
    }
}
</style>