import {defineConfig} from 'vitepress'

// https://vitepress.dev/reference/site-config
export default defineConfig({
	title: "JOCUSTOM",
	description: "Documentation for JOCUSTOM",
	componentsDir: '../components',
	themeConfig: {
		// https://vitepress.dev/reference/default-theme-config
		/*nav: [
			{text: 'Home', link: '/'},
			{text: 'Guide', link: '/introduction'}
		],
*/
		/*sidebar: [
			{
				text: 'Getting Started',
				items: [
					{text: 'Introduction', link: '/introduction'},
					{
						text: 'Installation',  items: [
							{
                              text: 'Shopify', link: '/shopify'
                            },
                            {
                              text: 'Shopline', link: '/shopline'
                            }
						]
					},
					{
						text: 'Configuration',  items: [
							{
								text: 'Shopify', link: '/shopify_conf'
							},
							{
								text: 'Shopline', link: '/shopline_conf'
							}
						]
					},
				]
			},
			{
				text: 'Application',
				items: [
					{text: 'Login', link: '/app/login'},
					{text: 'Design', link: '/app/design/', items: [
							{text: 'Customize', link: '/app/design/customize'}
						]},
					{text: 'Product', link: '/app/product/', items: [
							{text: 'Edit and Sync', link: '/app/product/edit'}
						]},
					{text: 'Order', link: '/app/order'},
					{text: 'Material', link: '/app/material/'},
					{text: 'Invoices', link: '/app/invoice'},
					{text: 'SizeChart', link: '/app/size_chart'},
					{text: 'Recharge', link: '/app/recharge'},
				]
			},
			{
				text: 'Website Terms',
				items: [
					{text: 'Shipping Policy', link: '/web/shipping-policy'},
					{text: 'Return Policy', link: '/web/return-policy'},
					{text: 'Contact Us', link: '/web/contact-us'},
					{text: 'Privacy Policy', link: '/web/privacy-policy'},
					{text: 'Terms & Conditions', link: '/web/terms-and-conditions'},
					{text: 'About Us', link: '/web/about-us'},
				]
			}
		],*/
		/*footer: {
			message: 'Released under the MIT License.',
			copyright: 'Copyright © 2019-present Evan You'
		}*/

		/*socialLinks: [
			{icon: 'github', link: 'https://github.com/vuejs/vitepress'}
		]*/
	},
	locales: {
		root: {
			label: 'English',
			lang: 'en',
			link: '/',
			title: "JOCUSTOM",
			description: "Documentation for JOCUSTOM",
			themeConfig: {
				// https://vitepress.dev/reference/default-theme-config
				nav: [
					{text: 'Home', link: '/'},
					{text: 'Guide', link: '/introduction'}
				],

				sidebar: [
					{
						text: 'Getting Started',
						items: [
							{text: 'Introduction', link: '/introduction'},
							{
								text: 'Installation',  items: [
									{
										text: 'Shopify', link: '/shopify'
									},
									{
										text: 'Shopline', link: '/shopline'
									}
								]
							},
							{
								text: 'Configuration',  items: [
									{
										text: 'Shopify', link: '/shopify_conf'
									},
									{
										text: 'Shopline', link: '/shopline_conf'
									}
								]
							},
						]
					},
					{
						text: 'Application',
						items: [
							{text: 'Login', link: '/app/login'},
							{text: 'Design', link: '/app/design/', items: [
									{text: 'Customize', link: '/app/design/customize'}
								]},
							{text: 'Product', link: '/app/product/', items: [
									{text: 'Edit and Sync', link: '/app/product/edit'}
								]},
							{text: 'Order', link: '/app/order'},
							{text: 'Material', link: '/app/material/'},
							{text: 'Invoices', link: '/app/invoice'},
							{text: 'SizeChart', link: '/app/size_chart'},
							{text: 'Recharge', link: '/app/recharge'},
						]
					},
					{
						text: 'Website Terms',
						items: [
							{text: 'Shipping Policy', link: '/web/shipping-policy'},
							{text: 'Return Policy', link: '/web/return-policy'},
							{text: 'Contact Us', link: '/web/contact-us'},
							{text: 'Privacy Policy', link: '/web/privacy-policy'},
							{text: 'Terms & Conditions', link: '/web/terms-and-conditions'},
							{text: 'About Us', link: '/web/about-us'},
						]
					}
				],
				socialLinks: [
					{
						icon: {
							svg: '<svg t="1763345352491" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1580" xmlns:xlink="http://www.w3.org/1999/xlink" width="200" height="200"><path d="M511.36 85.333333C276.906667 85.333333 85.333333 276.48 85.333333 512s191.573333 426.666667 426.026667 426.666667C747.093333 938.666667 938.666667 747.52 938.666667 512S747.093333 85.333333 511.36 85.333333zM423.125333 873.301333l-55.466666-221.952 196.650666 234.282667s-86.954667 11.093333-141.184-12.330667z m160.085334 6.186667c-76.714667-90.197333-153.6-180.224-230.656-270.08l365.525333 207.189333s-31.488 39.466667-134.826667 62.890667h-0.042666z m147.498666-70.314667a211401.813333 211401.813333 0 0 1-376.917333-220.714666l-63.018667-224.426667s-3.754667-19.754667-1.28-29.610667c1.28-6.144 21.461333-12.330667 21.461334-12.330666l230.656-64.128s204.202667 102.4 344.106666 176.341333c32.768 149.205333-69.333333 318.165333-155.008 374.869333zM466.005333 376.362667c-27.733333 0-49.152 22.186667-49.152 49.322666 0 27.136 21.418667 49.322667 49.152 49.322667 27.733333 0 49.152-22.186667 49.152-49.322667 0-27.136-21.418667-49.322667-49.152-49.322666z" fill="#181D2E" p-id="1581"></path></svg>',
						},
						link: 'https://apps.shopline.com/detail?appHandle=jocustom'
					},
					{
						icon: {
							svg: '<svg t="1763345385107" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2607" xmlns:xlink="http://www.w3.org/1999/xlink" width="200" height="200"><path d="M875.178667 198.4512a9.557333 9.557333 0 0 0-3.106134-5.802667 9.898667 9.898667 0 0 0-6.144-2.4576c-4.232533 0-78.4384-1.672533-78.4384-1.672533s-45.533867-42.973867-62.395733-59.4944v893.3376L989.866667 957.952S876.032 203.400533 875.178667 198.4512zM665.258667 129.024a238.08 238.08 0 0 0-15.189334-36.352C628.0192 51.370667 595.217067 28.945067 556.373333 28.945067a32.221867 32.221867 0 0 0-8.430933 0.8192C547.157333 28.125867 545.450667 27.306667 544.631467 25.668267c-16.861867-18.1248-38.775467-26.385067-64.955734-25.6-50.517333 1.6384-101.102933 37.137067-141.653333 100.795733-28.672 44.612267-50.551467 100.829867-56.490667 144.622933-58.197333 17.339733-98.645333 29.764267-99.498666 30.583467-29.4912 9.079467-30.378667 9.898667-33.723734 37.137067C145.783467 333.858133 68.266667 915.6608 68.266667 915.6608L705.672533 1024V119.125333c-3.072 0.1024-6.178133 0.341333-9.250133 0.8192 0 0-11.810133 3.2768-31.197867 9.079467z m-116.394667 35.5328c-33.6896 9.898667-70.826667 21.504-107.076267 32.221867 10.103467-38.843733 30.378667-77.687467 53.9648-103.2192 9.284267-9.079467 21.947733-19.831467 36.2496-26.453334 14.336 29.696 17.749333 70.178133 16.861867 97.450667zM479.675733 33.9968c10.615467-0.341333 21.162667 2.218667 30.378667 7.338667-13.482667 6.621867-26.965333 17.373867-39.594667 29.764266-32.085333 33.8944-56.5248 86.698667-66.628266 137.181867l-88.4736 26.4192c18.432-79.2576 86.7328-199.0656 164.317866-200.704z m-97.792 454.519467c3.3792 52.872533 145.885867 64.443733 154.282667 189.201066 5.905067 98.372267-53.111467 165.307733-138.274133 170.257067-102.877867 6.621867-159.368533-52.906667-159.368534-52.906667l21.9136-90.794666s56.490667 42.154667 102.058667 38.843733c29.4912-1.6384 40.482133-25.6 39.594667-42.154667-4.1984-69.393067-120.558933-65.297067-128.170667-179.3024-6.724267-95.914667 57.344-192.580267 198.997333-201.659733 54.784-3.310933 82.670933 9.898667 82.670934 9.898667l-32.0512 118.920533s-36.2496-16.4864-79.2576-13.2096c-62.395733 4.164267-63.249067 42.973867-62.395734 52.906667z m200.704-333.892267c0-24.7808-3.413333-60.3136-15.189333-90.077867 38.775467 7.441067 57.344 49.5616 65.774933 75.229867-15.189333 4.096-32.0512 9.079467-50.5856 14.848z" fill="#373537" p-id="2608"></path></svg>',
						},
						link: 'https://apps.shopify.com/jocustom?locale=zh-CN&search_id=7390c67c-2e46-43ed-8822-226972934380&surface_detail=jocustom&surface_inter_position=1&surface_intra_position=1&surface_type=search'
					}
				]
				/*footer: {
					message: 'Released under the MIT License.',
					copyright: 'Copyright © 2019-present Evan You'
				}*/

				/*socialLinks: [
					{icon: 'github', link: 'https://github.com/vuejs/vitepress'}
				]*/
			},
		},
		cn: {
			label: '简体中文',
			lang: 'cn',
			link: '/cn/',
			title: "JOCUSTOM",
			description: "JOCUSTOM 应用文档",
			themeConfig: {
				// https://vitepress.dev/reference/default-theme-config
				nav: [
					{text: '首页', link: '/cn'},
					{text: '文档', link: '/cn/introduction'}
				],

				sidebar: [
					{
						text: '快速上手',
						items: [
							{text: '介绍', link: '/cn/introduction'},
							{
								text: '安装',  items: [
									{
										text: 'Shopify', link: '/cn/shopify'
									},
									{
										text: 'Shopline', link: '/cn/shopline'
									}
								]
							},
							{
								text: '配置',  items: [
									{
										text: 'Shopify', link: '/cn/shopify_conf'
									},
									{
										text: 'Shopline', link: '/cn/shopline_conf'
									}
								]
							},
						]
					},
					{
						text: '应用',
						items: [
							{text: '登录', link: '/cn/app/login'},
							{text: '模板', link: '/cn/app/design/', items: [
									{text: '定制', link: '/cn/app/design/customize'}
								]},
							{text: '产品', link: '/cn/app/product/', items: [
									{text: '修改和同步', link: '/cn/app/product/edit'}
								]},
							{text: '订单', link: '/cn/app/order'},
							{text: '素材', link: '/cn/app/material/'},
							{text: '发票', link: '/cn/app/invoice'},
							{text: '尺码表', link: '/cn/app/size_chart'},
							{text: '充值', link: '/cn/app/recharge'},
						]
					},
					{
						text: '网站条款',
						items: [
							{text: '物流政策', link: '/cn/web/shipping-policy'},
							{text: '退换货政策', link: '/cn/web/return-policy'},
							{text: '联系我们', link: '/cn/web/contact-us'},
							{text: '隐私政策', link: '/cn/web/privacy-policy'},
							{text: '条款条约', link: '/cn/web/terms-and-conditions'},
							{text: '关于我们', link: '/cn/web/about-us'},
						]
					}
				],
				socialLinks: [
					{
						icon: {
							svg: '<svg t="1763345352491" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1580" xmlns:xlink="http://www.w3.org/1999/xlink" width="200" height="200"><path d="M511.36 85.333333C276.906667 85.333333 85.333333 276.48 85.333333 512s191.573333 426.666667 426.026667 426.666667C747.093333 938.666667 938.666667 747.52 938.666667 512S747.093333 85.333333 511.36 85.333333zM423.125333 873.301333l-55.466666-221.952 196.650666 234.282667s-86.954667 11.093333-141.184-12.330667z m160.085334 6.186667c-76.714667-90.197333-153.6-180.224-230.656-270.08l365.525333 207.189333s-31.488 39.466667-134.826667 62.890667h-0.042666z m147.498666-70.314667a211401.813333 211401.813333 0 0 1-376.917333-220.714666l-63.018667-224.426667s-3.754667-19.754667-1.28-29.610667c1.28-6.144 21.461333-12.330667 21.461334-12.330666l230.656-64.128s204.202667 102.4 344.106666 176.341333c32.768 149.205333-69.333333 318.165333-155.008 374.869333zM466.005333 376.362667c-27.733333 0-49.152 22.186667-49.152 49.322666 0 27.136 21.418667 49.322667 49.152 49.322667 27.733333 0 49.152-22.186667 49.152-49.322667 0-27.136-21.418667-49.322667-49.152-49.322666z" fill="#181D2E" p-id="1581"></path></svg>',
						},
						link: 'https://apps.shopline.com/detail?appHandle=jocustom'
					},
					{
						icon: {
							svg: '<svg t="1763345385107" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2607" xmlns:xlink="http://www.w3.org/1999/xlink" width="200" height="200"><path d="M875.178667 198.4512a9.557333 9.557333 0 0 0-3.106134-5.802667 9.898667 9.898667 0 0 0-6.144-2.4576c-4.232533 0-78.4384-1.672533-78.4384-1.672533s-45.533867-42.973867-62.395733-59.4944v893.3376L989.866667 957.952S876.032 203.400533 875.178667 198.4512zM665.258667 129.024a238.08 238.08 0 0 0-15.189334-36.352C628.0192 51.370667 595.217067 28.945067 556.373333 28.945067a32.221867 32.221867 0 0 0-8.430933 0.8192C547.157333 28.125867 545.450667 27.306667 544.631467 25.668267c-16.861867-18.1248-38.775467-26.385067-64.955734-25.6-50.517333 1.6384-101.102933 37.137067-141.653333 100.795733-28.672 44.612267-50.551467 100.829867-56.490667 144.622933-58.197333 17.339733-98.645333 29.764267-99.498666 30.583467-29.4912 9.079467-30.378667 9.898667-33.723734 37.137067C145.783467 333.858133 68.266667 915.6608 68.266667 915.6608L705.672533 1024V119.125333c-3.072 0.1024-6.178133 0.341333-9.250133 0.8192 0 0-11.810133 3.2768-31.197867 9.079467z m-116.394667 35.5328c-33.6896 9.898667-70.826667 21.504-107.076267 32.221867 10.103467-38.843733 30.378667-77.687467 53.9648-103.2192 9.284267-9.079467 21.947733-19.831467 36.2496-26.453334 14.336 29.696 17.749333 70.178133 16.861867 97.450667zM479.675733 33.9968c10.615467-0.341333 21.162667 2.218667 30.378667 7.338667-13.482667 6.621867-26.965333 17.373867-39.594667 29.764266-32.085333 33.8944-56.5248 86.698667-66.628266 137.181867l-88.4736 26.4192c18.432-79.2576 86.7328-199.0656 164.317866-200.704z m-97.792 454.519467c3.3792 52.872533 145.885867 64.443733 154.282667 189.201066 5.905067 98.372267-53.111467 165.307733-138.274133 170.257067-102.877867 6.621867-159.368533-52.906667-159.368534-52.906667l21.9136-90.794666s56.490667 42.154667 102.058667 38.843733c29.4912-1.6384 40.482133-25.6 39.594667-42.154667-4.1984-69.393067-120.558933-65.297067-128.170667-179.3024-6.724267-95.914667 57.344-192.580267 198.997333-201.659733 54.784-3.310933 82.670933 9.898667 82.670934 9.898667l-32.0512 118.920533s-36.2496-16.4864-79.2576-13.2096c-62.395733 4.164267-63.249067 42.973867-62.395734 52.906667z m200.704-333.892267c0-24.7808-3.413333-60.3136-15.189333-90.077867 38.775467 7.441067 57.344 49.5616 65.774933 75.229867-15.189333 4.096-32.0512 9.079467-50.5856 14.848z" fill="#373537" p-id="2608"></path></svg>',
						},
						link: 'https://apps.shopify.com/jocustom?locale=zh-CN&search_id=7390c67c-2e46-43ed-8822-226972934380&surface_detail=jocustom&surface_inter_position=1&surface_intra_position=1&surface_type=search'
					}
				]
			},
		}
	},
	markdown: {
		image: {
			// 默认禁用；设置为 true 可为所有图片启用懒加载。
			lazyLoading: true
		}
	}
})
