# Order

This section will explain how to view the order list and details for your linked store.

## Order List

When a customer places an order in your store, our app will collect that order and include only information about products pushed to the store by the app.

![Customizer for merchant](/assets/order/1.png)

When an order fails to sync from the store to the app backend, the error message shown below will appear. You may contact the administrator to check and handle the issue.

![Customizer for merchant](/assets/order/2.png)


## Order Status
1. Pending - Order synced from store to app, but order cost price remains in payment status
2. Pending Production - Order cost price paid and order pushed to factory, but factory has not confirmed
3. In Production - Factory has confirmed the order
4. Intercepting - Order status when requesting factory to intercept production or shipment
5. Intercepted - Factory successfully processed the order's intercept request. If failed, status remains Production in Progress.
6. Fulfilled - Status when the factory completes order shipment processing.
7. Refunding - Order status when a refund is requested.
8. Refunded - Order status when the refund request is approved.
9. Cancelled - Status after cancellation when the order cost price remains unpaid.


::: tip
You can filter and search the list based on the order status bar above.
:::

## Order Details

Click the View button to display the order details page, which includes the shipping method, custom product display, total amount, and order status section.

![Customizer for merchant](/assets/order/3.png)

![Customizer for merchant](/assets/order/4.png)