import {defineConfig} from 'vitepress'

// https://vitepress.dev/reference/site-config
export default defineConfig({
	title: "JOCUSTOM",
	description: "Documentation for JOCUSTOM",
	themeConfig: {
		// https://vitepress.dev/reference/default-theme-config
		/*nav: [
			{text: 'Home', link: '/'},
			{text: 'Guide', link: '/introduction'}
		],
*/
		/*sidebar: [
			{
				text: 'Getting Started',
				items: [
					{text: 'Introduction', link: '/introduction'},
					{
						text: 'Installation',  items: [
							{
                              text: 'Shopify', link: '/shopify'
                            },
                            {
                              text: 'Shopline', link: '/shopline'
                            }
						]
					},
					{
						text: 'Configuration',  items: [
							{
								text: 'Shopify', link: '/shopify_conf'
							},
							{
								text: 'Shopline', link: '/shopline_conf'
							}
						]
					},
				]
			},
			{
				text: 'Application',
				items: [
					{text: 'Login', link: '/app/login'},
					{text: 'Design', link: '/app/design/', items: [
							{text: 'Customize', link: '/app/design/customize'}
						]},
					{text: 'Product', link: '/app/product/', items: [
							{text: 'Edit and Sync', link: '/app/product/edit'}
						]},
					{text: 'Order', link: '/app/order'},
					{text: 'Material', link: '/app/material/'},
					{text: 'Invoices', link: '/app/invoice'},
					{text: 'SizeChart', link: '/app/size_chart'},
					{text: 'Recharge', link: '/app/recharge'},
				]
			},
			{
				text: 'Website Terms',
				items: [
					{text: 'Shipping Policy', link: '/web/shipping-policy'},
					{text: 'Return Policy', link: '/web/return-policy'},
					{text: 'Contact Us', link: '/web/contact-us'},
					{text: 'Privacy Policy', link: '/web/privacy-policy'},
					{text: 'Terms & Conditions', link: '/web/terms-and-conditions'},
					{text: 'About Us', link: '/web/about-us'},
				]
			}
		],*/
		/*footer: {
			message: 'Released under the MIT License.',
			copyright: 'Copyright © 2019-present Evan You'
		}*/

		/*socialLinks: [
			{icon: 'github', link: 'https://github.com/vuejs/vitepress'}
		]*/
	},
	locales: {
		root: {
			label: 'English',
			lang: 'en',
			link: '/',
			title: "JOCUSTOM",
			description: "Documentation for JOCUSTOM",
			themeConfig: {
				// https://vitepress.dev/reference/default-theme-config
				nav: [
					{text: 'Home', link: '/'},
					{text: 'Guide', link: '/introduction'}
				],

				sidebar: [
					{
						text: 'Getting Started',
						items: [
							{text: 'Introduction', link: '/introduction'},
							{
								text: 'Installation',  items: [
									{
										text: 'Shopify', link: '/shopify'
									},
									{
										text: 'Shopline', link: '/shopline'
									}
								]
							},
							{
								text: 'Configuration',  items: [
									{
										text: 'Shopify', link: '/shopify_conf'
									},
									{
										text: 'Shopline', link: '/shopline_conf'
									}
								]
							},
						]
					},
					{
						text: 'Application',
						items: [
							{text: 'Login', link: '/app/login'},
							{text: 'Design', link: '/app/design/', items: [
									{text: 'Customize', link: '/app/design/customize'}
								]},
							{text: 'Product', link: '/app/product/', items: [
									{text: 'Edit and Sync', link: '/app/product/edit'}
								]},
							{text: 'Order', link: '/app/order'},
							{text: 'Material', link: '/app/material/'},
							{text: 'Invoices', link: '/app/invoice'},
							{text: 'SizeChart', link: '/app/size_chart'},
							{text: 'Recharge', link: '/app/recharge'},
						]
					},
					{
						text: 'Website Terms',
						items: [
							{text: 'Shipping Policy', link: '/web/shipping-policy'},
							{text: 'Return Policy', link: '/web/return-policy'},
							{text: 'Contact Us', link: '/web/contact-us'},
							{text: 'Privacy Policy', link: '/web/privacy-policy'},
							{text: 'Terms & Conditions', link: '/web/terms-and-conditions'},
							{text: 'About Us', link: '/web/about-us'},
						]
					}
				],
				/*footer: {
					message: 'Released under the MIT License.',
					copyright: 'Copyright © 2019-present Evan You'
				}*/

				/*socialLinks: [
					{icon: 'github', link: 'https://github.com/vuejs/vitepress'}
				]*/
			},
		},
		cn: {
			label: '简体中文',
			lang: 'cn',
			link: '/cn/',
			title: "JOCUSTOM",
			description: "JOCUSTOM 应用文档",
			themeConfig: {
				// https://vitepress.dev/reference/default-theme-config
				nav: [
					{text: '首页', link: '/cn'},
					{text: '文档', link: '/cn/introduction'}
				],

				sidebar: [
					{
						text: '快速上手',
						items: [
							{text: '介绍', link: '/cn/introduction'},
							{
								text: '安装',  items: [
									{
										text: 'Shopify', link: '/cn/shopify'
									},
									{
										text: 'Shopline', link: '/cn/shopline'
									}
								]
							},
							{
								text: '配置',  items: [
									{
										text: 'Shopify', link: '/cn/shopify_conf'
									},
									{
										text: 'Shopline', link: '/cn/shopline_conf'
									}
								]
							},
						]
					},
					{
						text: '应用',
						items: [
							{text: '登录', link: '/cn/app/login'},
							{text: '模板', link: '/cn/app/design/', items: [
									{text: 'Customize', link: '/cn/app/design/customize'}
								]},
							{text: '产品', link: '/cn/app/product/', items: [
									{text: 'Edit and Sync', link: '/cn/app/product/edit'}
								]},
							{text: '订单', link: '/cn/app/order'},
							{text: '素材', link: '/cn/app/material/'},
							{text: '发票', link: '/cn/app/invoice'},
							{text: '尺码表', link: '/cn/app/size_chart'},
							{text: '充值', link: '/cn/app/recharge'},
						]
					},
					{
						text: '网站条款',
						items: [
							{text: '物流政策', link: '/cn/web/shipping-policy'},
							{text: '退换货政策', link: '/cn/web/return-policy'},
							{text: '联系我们', link: '/cn/web/contact-us'},
							{text: '隐私政策', link: '/cn/web/privacy-policy'},
							{text: '条款条约', link: '/cn/web/terms-and-conditions'},
							{text: '关于我们', link: '/cn/web/about-us'},
						]
					}
				],
			},
		}
	},
	markdown: {
		image: {
			// 默认禁用；设置为 true 可为所有图片启用懒加载。
			lazyLoading: true
		}
	}
})
