/*
 * @Description: 描述
 * @Author: chd
 * @Date: 2020-05-20 17:48:30
 * @LastEditors: chd
 * @LastEditTime: 2021-04-22 17:09:23
 */

const isprd = process.env.NODE_ENV === 'production'
const timeTamp = new Date().getTime()
// const SentryWebpackPlugin = require("@sentry/webpack-plugin");
module.exports = {
  publicPath: process.env.NODE_ENV === 'production'? './' :'/',
  // assetsDir: 'static',
  lintOnSave: process.env.NODE_ENV !== 'production',
  productionSourceMap: false,
  chainWebpack: (config) => {
    //打包检测
    if (isprd) {
      if (process.env.npm_config_report) {
        config
          .plugin('webpack-bundle-analyzer')
          .use(require('webpack-bundle-analyzer').BundleAnalyzerPlugin)
          .end()
      }
      config
        .plugin('gzip-plugin')
        .use('compression-webpack-plugin', [
          {
            filename: '[path][base].gz',
            algorithm: 'gzip',
            test: /\.js$|\.html$|\.json$|\.css$|\.ttf$/,
            threshold: 10240, // 只有大小大于该值的资源会被处理
            // minRatio: 0.8, // 只有压缩率小于这个值的资源才会被处理
            deleteOriginalAssets: false, // 删除原文件
          },
        ])
        .end()
      config.plugins.delete('prefetch')
      config.plugins.delete('preload')
    }
    // ============注入cdn start============
    config.plugin('html').tap((args) => {
      args[0].cdn = {
        css: [],
        js: [
          // "https://cdn.jsdelivr.net/npm/echarts@5.1.0/dist/echarts.min.js",
        ],
      }
      return args
    })
  },
  configureWebpack: (config) => {
    config.output.filename = `assets/js/[name].${timeTamp}.js`
    config.output.chunkFilename = `assets/js/[name].${timeTamp}.js`
    config.performance = {
      maxEntrypointSize: 50000000,
      maxAssetSize: 30000000,
      hints: 'warning',
    }
    config.externals = {
      // echarts: "echarts",
      // moment: 'moment',
      // wangEditor: 'wangEditor',
      // XLSX: 'XLSX',
    }
  },
  css: {
    extract: {
      // 打包编译后修改 css 文件名
      filename: `assets/css/[name].${timeTamp}.css`,
      chunkFilename: `assets/css/[name].${timeTamp}.css`,
      ignoreOrder: true,
    },
  },
}
