/*
 * @Description: 描述
 * @Author: chd
 * @Date: 2021-04-27 20:55:41
 * @LastEditors: chd
 * @LastEditTime: 2021-06-10 18:14:18
 */
import axios from 'axios'
import Vue from 'vue'
import router from '../router'
const baseURL = window.apiHostSetting.VUE_APP_API_URL

let httpNum = 0
const instance = axios.create({
  baseURL: baseURL + 'api/',
  timeout: 5 * 60 * 1000,
  // headers: {
  //   "Content-Type": "application/x-www-form-urlencoded;charset=UTF-8",
  // },
  validateStatus: (status) => status >= 200 && status < 500, // 默认的
})
instance.interceptors.request.use(
  (config) => {
    httpNum++
    let usertoken = localStorage.getItem('token')
    if (usertoken) {
      config.headers['jwt-token'] = usertoken
    }
    return config
  },
  (error) => {
    return Promise.reject(error)
  }
)

// 响应拦截器
instance.interceptors.response.use(
  (res) => {
    httpNum--
    if (res.status === 200) {
      if (res.data.code === 401) {
        // token过期
        if (httpNum === 0) {
          Vue.prototype.$message({
            type: 'error',
            message: res.data.message,
          })
          sessionStorage.setItem('active', 'true')
          router
            .replace({
              name: 'login',
            })
            .catch((err) => {
              console.log(err)
            })
        }
        return Promise.reject(res.data)
      } else if (res.data.code === 402) {
        Vue.prototype.$message({ message: res.data.message, type: 'warning' })
        return Promise.reject(res.data)
      } else if (res.data.code === 500) {
        Vue.prototype.$alert(
          '<div style="max-height:500px;overflow:auto">' +
            res.data.message +
            '</div>',
          '错误提示',
          {
            dangerouslyUseHTMLString: true,
          }
        )
        return Promise.reject(res.data)
      } else {
        return Promise.resolve(res)
      }
    } else {
      switch (res.status) {
        case 400:
          Vue.prototype.$alert('请求参数有误', '提示', {
            confirmButtonText: '确定',
            callback: () => {},
          })
          break
        case 404:
          Vue.prototype.$alert('请求不存在', '提示', {
            confirmButtonText: '确定',
            callback: () => {},
          })
          break
        default:
          break
      }
      return Promise.reject(res)
    }
  },
  // 服务器状态码不是200的情况
  (error) => {
    httpNum--
    if (httpNum == 0) {
      Vue.prototype.$alert(error.message, {
        confirmButtonText: '确定',
        callback: () => {},
      })
    }
    return Promise.reject(error)
  }
)
export function get(url, params) {
  return new Promise((resolve, reject) => {
    instance
      .get(url, { params })
      .then((res) => {
        if (res.status === 200 && res.data) {
          resolve(res.data)
        } else {
          resolve(res)
        }
      })
      .catch((err) => {
        reject(err)
      })
  })
}
export function post(url, params, headers) {
  return new Promise((resolve, reject) => {
    instance
      .post(url, params, headers)
      .then((res) => {
        if (res.status === 200 && res.data) {
          resolve(res.data)
        } else {
          resolve(res)
        }
      })
      .catch((err) => {
        reject(err)
      })
  })
}
export default { get, post }
