/*
 * @Description: 描述
 * @Author: chd
 * @Date: 2021-01-18 13:49:02
 * @LastEditors: chd
 * @LastEditTime: 2021-04-27 21:40:51
 */

import { get, post } from './axios'
/**
 * 品牌
 * @param {Object} options
 * @param {String} options.brandName
 * @param {Number} options.categoryId
 * @param {Number} options.styleId
 * @returns Promise
 */
export const getBrandList = (options = {}) => post('brandWebsite/list', options)
/**
 * 公告
 * @returns Promise
 */
export const getBulletin = () => get('home/announcements')
/**
 * 字典
 * @param {String} code
 * @returns Promise
 */
export const getDictionary = (code) =>
  get('baseDictData/findDictByCode/' + code)
/**
 * 字典
 * @param {String} cateCode
 * @returns Promise
 */
export const getDictByCateCode = (cateCode) =>
  get('baseDictData/findDictByCateCode/' + cateCode)
/**
 * 表格展示项
 * @param {String} name
 * @returns Promise
 */
export const getColumn = (name) =>
  get('sysLogin/getColumn', {
    reqMenu: name,
  })
/**
 * 保存表格展示项
 * @param {String} path
 * @param {Object} data
 * @returns Promise
 */
export const saveColumns = (path, data) =>
  post('sysUserDisplayOption/save', {
    displayOption: JSON.stringify(data),
    pageName: path,
  })
/**
 * 删除表格展示项
 * @param {String} path
 * @returns Promise
 */
export const removeColumns = (path) =>
  post('sysUserDisplayOption/delete', {
    pageName: path,
  })
/**
 * 有权限的表格展示项
 * @param {String} type
 * @returns Promise
 */
export const getSysColumn = (type) => get('sysDataRole/findRoleColumns/' + type)
/**
 * 获取平台
 * @returns Promise
 */
export const getplatform = () => get('global/platform')
/**
 * 获取包装规格
 * @returns Promise
 */
export const getPackingSpecification = () => get('basePackingSpec/all_list')
//
/**
 * 员工列表
 * @returns Promise
 */
export const employeeList = () =>
  new Promise((resolve, reject) => {
    get('employee/userInServiceOption')
      .then((res) => {
        let data = res.data
        for (const iterator of data) {
          let name = iterator.name
          iterator.name = iterator.enName
          iterator.enName = name
        }
        resolve({ data })
      })
      .catch(reject)
  })
/**
 * 获取部门职员
 * @returns Promise
 */
export const getDepartmentStaff = () =>
  new Promise((resolve, reject) => {
    get('dept/allDeptAndEmp')
      .then((res) => {
        let arr = []
        for (const iterator of res.data) {
          let item = arr.find(
            (val) => val.value === 'deptId_' + iterator.deptId
          )

          if (item) {
            item.children.push({
              label: iterator.empName,
              value: iterator.empId,
              qyvxId: iterator.qyvxId,
              avatar: iterator.avatar,
              mobile: iterator.mobile,
            })
          } else {
            arr.push({
              value: 'deptId_' + iterator.deptId,
              label: iterator.deptName,
              children: [
                {
                  label: iterator.empName,
                  value: iterator.empId,
                  qyvxId: iterator.qyvxId,
                  avatar: iterator.avatar,
                  mobile: iterator.mobile,
                },
              ],
            })
          }
        }
        resolve({ data: arr })
      })
      .catch(reject)
  })
// 国家列表
const countryList = () => get('baseCountryCode/all_list')
// 币种列表
const currencyList = () => get('baseExchangeRateCur/getCurAll')
// 仓库列表
const warehouseList = () => get('warehouseInfo/can_use')
// 物流公司列表
const logisticsList = () => get('logisticsCompany/all_options')
// 可用物流公司列表
export const canlogisticsList = (companyCode) =>
  get('logisticsCompany/can_use', { companyCode })
// 物流方式列表
const logisticsModeList = () => get('logisticsWay/usableAllList')
// 站点列表
export const notRoleShopifyStores = () => get('shopifyShopInfo/shop_list')
// 加权站点列表
const storeListList = () => get('shopifyShopInfo/shop_options')

/**
 * 平台筛选站点列表
 * @param {Object} params
 * @param params.platform {string}  - 平台
 * @param params.adChannels {string} - 投放渠道
 * @returns Promise
 */

export const getPlatformStore = (params) => {
  params = params || {}
  if (typeof params !== 'object') {
    params = { platform: params }
  }

  return get('shopifyShopInfo/role_shop_list', params)
}

/**
 * 站点负责人
 * @param {String} platform 平台
 * @returns Promise
 */
export const siteOwner = (platform) =>
  get('shopifyShopInfo/shops_leader', { platform })
/**
 * 采购渠道
 * @returns Promise
 */
const purchaseChannelsList = () =>
  get('baseDictData/findDictByCode/supply_channel')

/**
 * 商品分类
 * @returns Promise
 */
const categories = () => get('baseCategoryInfo/tree_list_option')
//
/**
 * 商品风格
 * @param {Number} cateId 分类ID
 * @returns Promise
 */
export const getStyleList = (cateId) =>
  get('baseStyleInfo/listByCateId', {
    cateId,
  })
/**
 * 获取供应商
 * @returns Promise
 */
const supplierList = () => get('supplySupplier/getSupplierByPermission')

/**
 * 打印模板
 * @param {*} types 模板类型
 * @returns Promise
 */
export const printTemplate = (types) =>
  new Promise((resolve, reject) => {
    post('printTemplate/list_page', {
      currentPage: 1,
      pageSize: 100,
      typeList: types ? types.split(',') : [],
    })
      .then((res) => resolve({ ...res, data: res.data.records }))
      .catch(reject)
  })

/**
 * 自定义标签
 * @param {*} type  标签类型
 * @returns Promise
 */
export const customTagList = (type) =>
  get(`baseCustomTag/findListByType/${type}`)

export function get_options(name) {
  if (name === 'country') {
    return countryList()
  }
  if (name === 'currency') {
    return currencyList()
  }
  if (name === 'warehouse') {
    return warehouseList()
  }
  if (name === 'logistics') {
    return logisticsList()
  }
  if (name === 'logisticsMode') {
    return logisticsModeList()
  }
  if (name === 'employee') {
    return employeeList()
  }
  if (name === 'canlogistics') {
    return canlogisticsList()
  }
  if (name === 'storeList') {
    return storeListList()
  }
  if (name === 'purchaseChannels') {
    return purchaseChannelsList()
  }
  if (name === 'productCategory') {
    return categories()
  }
  if (name === 'supplierList') {
    return supplierList()
  }
  if (name === 'printOptions') {
    return printTemplate()
  }
}
/**
 * 上传图片
 * @param {*} params
 * @param {String} params.filePath - 文件存储文件夹
 * @param {object} ...other
 * @returns Promise
 */
export function upload_img(file, params = {}) {
  let from = new FormData()
  from.append('file', file)
  for (const key in params) {
    from.append(key, params[key])
  }
  return post(`upload/fileUpload/images`, from, {
    headers: { 'content-type': 'multipart/form-data' },
  })
}
export function upload_other_file(params) {
  const { url, name, file, ...other } = params
  let from = new FormData()
  for (const key in other) {
    from.append(key, other[key])
  }
  from.append(name, file)
  return post(url, from, {
    headers: { 'content-type': 'multipart/form-data' },
  })
}
