/*
 * @Description: 描述
 * @Author: chd
 * @Date: 2020-05-20 17:52:12
 * @LastEditors: chd
 * @LastEditTime: 2021-01-21 14:01:35
 */
import { get } from '../../utils/axios'
import Vue from 'vue'
const state = {
  orderItem: {},
  tableKey: 0,
  oldSelection: [],
}
const mutations = {
  setOrderItem(state, data) {
    state.orderItem = data
  },
  setTableKey(state, num) {
    state.tableKey = num
  },
  saveSelection(state, list) {
    state.oldSelection = list
  },
}
const actions = {
  setOrderItem({ commit }, { id }) {
    get('orderDetails/get', { id }).then((res) => {
      if (res.code == 200) {
        commit('setOrderItem', res.data)
      } else {
        Vue.prototype.$alert(res.message, '错误提示', {
          dangerouslyUseHTMLString: true,
        })
      }
    })
  },
  setTableKey({ commit }) {
    let num = Math.floor(Math.random() * (1 - 100) + 100)
    commit('setTableKey', num)
  },
  saveSelection({ commit }, list) {
    commit('saveSelection', list)
  },
}

export default { state, mutations, actions }
