import Vue from 'vue'
import Vuex from 'vuex'
Vue.use(Vuex)
import Order from './modules/order'
import im from './modules/im'
import roleAuth from './modules/roleAuth'
import supply from './modules/supply'
import { delChildren } from '../utils/commonUtil'

export default new Vuex.Store({
  // strict: process.env.NODE_ENV !== 'production',
  modules: {
    Order,
    im,
    roleAuth,
    supply,
  },
  state: {
    country: [], //国家列表
    currency: [], //币种列表
    warehouse: [], //仓库列表
    customTag: [], //自定义标签列表
    logistics: [], //物流公司列表
    logisticsMode: [], //物流方式列表
    employee: [], //员工列表
    purchaseChannels: [], //采购渠道
    productCategory: [], //产品类别
    supplierList: [], //供应商
    printOptions: [], //打印模板
    storeList: [],
    canlogistics: [],
    keyCode: null,
    showChat: false,
    //页面默认选项
    reqMenu: {
      buttons: [],
    },
    //导航标签
    tags: [
      {
        title: '首页',
        name: 'home',
        route: '/home',
      },
    ],
    tagsIndex: 0, //导航下标

    permissions: [],
    historyList: [],
    costomThemeVisible: false,
    navList: [], //快捷导航
    sysColumns: {},
    platformOptions: [],
  },
  mutations: {
    setState(state, options) {
      for (const key in options) {
        if (Object.prototype.hasOwnProperty.call(state, key)) {
          if (key === 'productCategory') {
            // 去除空的children
            try {
              state[key] = delChildren(options[key])
            } catch (error) {
              state[key] = options[key]
            }
          } else {
            state[key] = options[key]
          }
        }
      }
    },
    resetState(state) {
      const arr = ['Order', 'im', 'roleAuth', 'supply']
      for (const key in state) {
        if (arr.includes(key)) continue //跳过 modules
        if (key === 'reqMenu') continue //待优化
        if (Array.isArray(state[key])) {
          state[key] = []
        } else if (typeof state[key] === 'string') {
          state[key] = ''
        } else if (typeof state[key] === 'number') {
          state[key] = 0
        } else if (typeof state[key] === 'boolean') {
          state[key] = false
        } else if (typeof state[key] === 'object') {
          state[key] = {}
        } else {
          state[key] = ''
        }
        state.tagsIndex = 0
        state.tags = [{ title: '首页', name: 'home', route: '/home' }]
      }
    },
    loginout(state) {
      state.tags = [{ title: '首页', name: 'home', route: '/home' }]
      state.tagsIndex = 0
      state.permissions = []
    },
    set_route_premissions(state, msg) {
      state.permissions.push(msg)
    },
    modify_home_tabs(state, msg) {
      if (msg.length > 0) {
        state.tags = msg
      } else {
        state.tags = [{ title: '首页', name: 'home', route: '/home' }]
      }
    },
    modify_activeIndex(state, msg) {
      state.tagsIndex = msg
    },
    modify_reqMenu(state, msg) {
      state.reqMenu = msg
    },
    setSysColumns(state, options) {
      for (const key in options) {
        state.sysColumns[key] = options[key]
      }
    },
    setKeyCode(state, msg) {
      state.keyCode = msg
    },
  },
  actions: {
    resetState({ commit }) {
      commit('resetState')
    },
    setState({ commit }, options) {
      commit('setState', options)
    },
    loginout({ commit }) {
      commit('loginout')
    },
    loginIn({ commit }, { msg }) {
      commit('loginIn', msg)
    },
    setSysColumns({ commit }, options) {
      commit('setSysColumns', options)
    },
    setKeyCode({ commit }, msg) {
      commit('setKeyCode', msg)
    },
    setMenuList({ commit }, list) {
      commit('modify_menulist', list)
    },
  },
})
