/*
 * @Description: file content
 * @Author: Huidong Che
 * @Date: 2020-03-27 08:53:27
 * @LastEditors: chd
 * @LastEditTime: 2021-05-08 15:35:09
 */
import Vue from 'vue'
import App from './App.vue'

import './plugins/element.js'
import './plugins/vxetable'
import './plugins/jsonViewer'

import store from './store'
import router from './router'
import './assets/css/root.css'
import './assets/css/common.css'
import moment from 'moment'
import { filePath, zImgPath } from './utils/axios'
import './mork'
import _ from 'lodash'
Vue.config.performance = true
Vue.config.productionTip = process.env.NODE_ENV !== 'production'

// 待优化
Vue.prototype.$moment = moment
// 待优化

// 日期格式化 待优化
Vue.filter('dateformat', function (dataStr, pattern = 'YYYY-MM-DD') {
  if (dataStr) {
    return moment(dataStr).format(pattern)
  } else {
    return dataStr
  }
})
//  待优化
// 权限校验
Vue.prototype.roleShow = (name) => {
  let roles = store.state.reqMenu.buttons
  if (!roles) return false
  if (Array.isArray(name)) {
    return name.some((key) => roles.includes(key))
  } else {
    return roles ? roles.includes(name) : false
  }
}
/**
 * 图片下载地址
 * w=width&h=height&g=isgray&x=position_x&y=position_y&r=rotate&q=quality&f=format
 * @param {*} url
 * @param {Object} options
 * @param {Number} options.w -width
 * @param {Number} options.w -height
 * @param {0 | 1}  options.g -isgray 灰色
 * @param {Number} options.x -position_x
 * @param {Number} options.y -position_y
 * @param {Number} options.r -rotate 旋转
 * @param {Number} options.q -quality 质量
 * @param {'jpeg' | 'png' | 'gif' | 'jeg'} options.f -format
 * @returns String
 */
const clientWidth = document.body.clientWidth
const dpi = _.add(_.ceil(_.divide(clientWidth / 1920)) + 0.5)
console.log('dpi', dpi)
Vue.prototype.setimgUrl = (url, options = {}) => {
  const { w, h, ...others } = options
  let query = ''
  if (w) {
    query += query ? '&w=' : 'w=' + _.floor(_.multiply(dpi * w))
  }
  if (h) {
    query += query ? '&h=' : 'h=' + _.floor(_.multiply(dpi * h))
  }
  for (const key in others) {
    query += `${query ? '&' : ''}${key}=${options[key]}`
  }

  if (!url) return ''
  if (/(http|https):\/\/([^/]+)/i.test(url)) {
    return url
  } else if (url.indexOf('/') === -1) {
    return zImgPath + url + (query ? '?' : '') + query
  } else {
    return filePath + url
  }
}
/**
 * 大数字转换
 * @param {*} num
 * @returns
 */
Vue.prototype.amountConversion = (num, cb) => {
  if (!num) return ['0', '']
  let text = ''
  if (num > 99999999) {
    text = [Math.floor(num / 10000000) / 10, '亿']
  } else if (num > 9999) {
    text = [Math.floor(num / 1000) / 10, '万']
  } else {
    text = [num, '']
  }
  if (cb) {
    return cb(num)
  }
  return text
}

new Vue({
  store,
  router,
  render: (h) => h(App),
}).$mount('#app')

Vue.config.errorHandler = function (err, vm, info) {
  // handle error
  // `info` 是 Vue 特定的错误信息，比如错误所在的生命周期钩子
  // 只在 2.2.0+ 可用
  console.log('错误', err, vm, info)
  // monitorPost('/error/save', { err, vm, info })
}
