# joshine-erp

## Project setup
```
npm install
```

### Compiles and hot-reloads for development
```
npm run serve
```

### Compiles and minifies for production
```
npm run build
```
### 打包不同环境
> 1. 新建[.env[mode]](https://cli.vuejs.org/zh/guide/mode-and-env.html#%E6%A8%A1%E5%BC%8F)文件
> 2. NODE_ENV=production    //生产环境
> 4. VUE_APP_BASE_API=[http://localhost:8081/](http://localhost:8081) //后端接口路径
> 5. 执行下面命令
> ```
> npm run build -- --mode [mode]
> ```

### Lints and fixes files
```
npm run lint
```

### Customize configuration
See [Configuration Reference](https://cli.vuejs.org/config/).

### 拒绝提交包含混合换行符的文件
```
git config --global core.safecrlf true
```
### 提交时转换为LF，检出时不转换
```
git config --global core.autocrlf input
```
### 提交检出均不转换
```
git config --global core.autocrlf false
```
```
erp_vue                                                         //
├─ .editorconfig                                                // vscode 配置
├─ .eslintrc.js                                                 // eslint 配置
├─ .prettierignore                                              // prettier 忽略文件
├─ .prettierrc                                                  // prettier 配置
├─ babel.config.js                                              // babel 配置
├─ element-variables.scss                                       // element 原始css 
├─ jsconfig.json                                                // js配置文件
├─ package-lock.json                                            // 
├─ package.json                                                 //
├─ public                                                       // 
│  ├─ config.js                                                 // api地址配置
│  ├─ error.html                                                //
│  ├─ favicon.ico                                               //
│  ├─ files                                                     // 导入模板
│  │  ├─ advertisingAccountTemplate.xlsx                        //
│  │  ├─ advertisingReconciliationttemplate.xlsx                //
│  │  ├─ costTemplate.xlsx                                      //
│  │  ├─ emailtemplate.xlsx                                     //
│  │  ├─ LogisticsReconciliationDataTemplate.xlsx               //
│  │  ├─ SalaryPerformanceTmportTemplate.xlsx                   //
│  │  ├─ trackingNumber.xlsx                                    //
│  │  └─ warehouseLocationTemplate.xlsx                         //
│  ├─ images                                                    // 图片
│  │  ├─ background                                             //
│  │  │  ├─ bg-1.png                                            //
│  │  │  ├─ bg-2.jpg                                            //
│  │  │  ├─ bg-3.png                                            //
│  │  │  ├─ bg-4.png                                            //
│  │  │  └─ bg-5.png                                            //
│  │  └─ icon                                                   //
│  │     ├─ logo-1.png                                          //
│  │     ├─ logo-2.png                                          //
│  │     ├─ logo-3.png                                          //
│  │     ├─ logo-4.png                                          //
│  │     ├─ logo-5.png                                          //
│  │     └─ logo-6.png                                          //
│  ├─ index.html                                                //
│  ├─ wangEditor.min.js                                         // 
│  └─ xlsx.core.min.js                                          //
├─ README.md                                                    //
├─ src                                                          //
│  ├─ App.vue                                                   // 
│  ├─ assets                                                    //
│  │  ├─ audio                                                  // 音频
│  │  ├─ css                                                    // 
│  │  │  ├─ common.css                                          //
│  │  │  └─ root.css                                            //
│  │  ├─ fonts                                                  //
│  │  │  ├─ Alibaba-PuHuiTi-Bold.ttf                            //
│  │  │  ├─ Alibaba-PuHuiTi-Heavy.ttf                           //
│  │  │  ├─ Alibaba-PuHuiTi-Light.ttf                           //
│  │  │  ├─ Alibaba-PuHuiTi-Medium.ttf                          //
│  │  │  └─ Alibaba-PuHuiTi-Regular.ttf                         //
│  │  ├─ icon                                                   //
│  │  │  ├─ home                                                // 图标
│  │  │  ├─ media                                               //
│  │  ├─ iconfont                                               //
│  │  ├─ image                                                  //
│  │  ├─ images                                                 // 图片
│  │  │  ├─ adaccount                                           //
│  │  │  ├─ ae                                                  //
│  │  │  ├─ background                                          //
│  │  │  ├─ common                                              //
│  │  │  ├─ emjoy                                               //
│  │  │  │  └─ face                                             //
│  │  │  ├─ enterprise                                          //
│  │  │  ├─ head                                                //
│  │  │  ├─ home                                                //
│  │  │  ├─ login                                               //
│  │  │  ├─ mobile                                              //
│  │  │  ├─ platform                                            //
│  │  │  ├─ SF                                                  //
│  │  │  ├─ supply                                              //
│  │  │  ├─ task                                                //
│  │  │  └─ userPortrait                                        //
│  │  ├─ img                                                    //
│  │  └─ js                                                     //
│  │     ├─ tracking_code.js                                    //
│  │     └─ world.js                                            //
│  ├─ components                                                // 组件
│  │  ├─ base                                                   // 基础组件
│  │  │  ├─ checkbox-btn.vue                                    // 自定义多选
│  │  │  ├─ checkbox.vue                                        //
│  │  │  ├─ cron.vue                                            // 定时任务选择时间
│  │  │  ├─ custom-column-table.vue                             // 表格自定义列
│  │  │  ├─ image-list.vue                                      // 多张图片上传
│  │  │  ├─ image.vue                                           // 图片 
│  │  │  ├─ input-tag.vue                                       // 输入内容以标签形式展示
│  │  │  ├─ navbar.vue                                          // 导航
│  │  │  ├─ status-list.vue                                     // 状态列表
│  │  │  ├─ table.vue                                           // vxe-table 表格
│  │  │  ├─ tabs.vue                                            // tabs
│  │  │  ├─ tools                                               // 工具
│  │  │  │  └─ index.vue                                        //
│  │  │  └─ upload-image.vue                                    // 单张图片上传
│  │  ├─ calendar.vue                                           // 日历
│  │  ├─ color-picker.vue                                       // 颜色选择
│  │  ├─ communication                                          // 聊天
│  │  │  ├─ emjoy.vue                                           //
│  │  │  ├─ iminput.vue                                         //
│  │  │  ├─ index.vue                                           //
│  │  │  └─ qq-emjoy.vue                                        //
│  │  ├─ custom-theme.vue                                       // 自定义主题
│  │  ├─ customTag.vue                                          // 自定义标签
│  │  ├─ editor.vue                                             // 富文本
│  │  ├─ global                                                 // 全局引入组件
│  │  │  ├─ adaptive-image.vue                                  // 自适应图片
│  │  │  ├─ chooseTimePeriod.vue                                // 时间选择
│  │  │  ├─ drag.vue                                            // 拖拽
│  │  │  ├─ ImageView.vue                                       // 表格图片
│  │  │  ├─ layout.vue                                          //
│  │  │  ├─ OrderTable.vue                                      // el-table 支持自定义column
│  │  │  ├─ pagination.vue                                      // 分页
│  │  │  ├─ select.vue                                          // 查询
│  │  │  ├─ store-select.vue                                    // 店铺查询
│  │  │  └─ TableView.vue                                       // el-table 
│  │  ├─ Head.vue                                               // 
│  │  ├─ ImgList.vue                                            // 图片列表
│  │  ├─ imgscroll.vue                                          // 
│  │  ├─ navigation                                             // 导航
│  │  │  ├─ edit.vue                                            //
│  │  │  └─ index.vue                                           //
│  │  ├─ printDialog.vue                                        // 打印弹窗
│  │  ├─ rightMenu.vue                                          // 右键菜单
│  │  ├─ skuAttributeSelection.vue                              // sku属性选择
│  │  ├─ skuAttributeSelection1.vue                             // 
│  │  └─ suspension.vue                                         // 快捷导航
│  ├─ json                                                      //
│  │  ├─ homeSummary.json                                       // 待办事项
│  │  └─ platform.json                                          // 站点平台
│  ├─ language                                                  //
│  │  ├─ cn.js                                                  //
│  │  ├─ en.js                                                  //
│  │  └─ index.js                                               //
│  ├─ main.js                                                   //
│  ├─ mixins                                                    //
│  │  └─ pagination.js                                          //
│  ├─ mork                                                      //
│  │  └─ index.js                                               //
│  ├─ plugins                                                   //
│  │  ├─ element.js                                             // element 
│  │  ├─ myui.js                                                // 
│  │  └─ vxetable.js                                            // vxe-table
│  ├─ router                                                    //
│  │  ├─ basics.js                                              //
│  │  ├─ development.js                                         //
│  │  ├─ financial.js                                           //
│  │  ├─ index.js                                               //
│  │  ├─ log.js                                                 //
│  │  ├─ logistics.js                                           //
│  │  ├─ market.js                                              //
│  │  ├─ mobile.js                                              //
│  │  ├─ order.js                                               //
│  │  ├─ personalCenter.js                                      //
│  │  ├─ platform.js                                            //
│  │  ├─ purchase.js                                            //
│  │  ├─ statistics.js                                          //
│  │  ├─ supplier.js                                            //
│  │  ├─ supply.js                                              //
│  │  ├─ system.js                                              //
│  │  ├─ task.js                                                //
│  │  └─ warehouse.js                                           //
│  ├─ store                                                     //
│  │  ├─ index.js                                               //
│  │  └─ modules                                                //
│  │     ├─ im.js                                               //
│  │     ├─ order.js                                            //
│  │     ├─ roleAuth.js                                         //
│  │     └─ supply.js                                           //
│  ├─ theme                                                     //
│  │  ├─ alert.css                                              //
│  │  ├─ aside.css                                              //
│  │  ├─ autocomplete.css                                       //
│  │  ├─ avatar.css                                             //
│  │  ├─ backtop.css                                            //
│  │  ├─ badge.css                                              //
│  │  ├─ base.css                                               //
│  │  ├─ breadcrumb-item.css                                    //
│  │  ├─ breadcrumb.css                                         //
│  │  ├─ button-group.css                                       //
│  │  ├─ button.css                                             //
│  │  ├─ calendar.css                                           //
│  │  ├─ card.css                                               //
│  │  ├─ carousel-item.css                                      //
│  │  ├─ carousel.css                                           //
│  │  ├─ cascader-panel.css                                     //
│  │  ├─ cascader.css                                           //
│  │  ├─ checkbox-button.css                                    //
│  │  ├─ checkbox-group.css                                     //
│  │  ├─ checkbox.css                                           //
│  │  ├─ col.css                                                //
│  │  ├─ collapse-item.css                                      //
│  │  ├─ collapse.css                                           //
│  │  ├─ color-picker.css                                       //
│  │  ├─ container.css                                          //
│  │  ├─ date-picker.css                                        //
│  │  ├─ dialog.css                                             //
│  │  ├─ display.css                                            //
│  │  ├─ divider.css                                            //
│  │  ├─ drawer.css                                             //
│  │  ├─ dropdown-item.css                                      //
│  │  ├─ dropdown-menu.css                                      //
│  │  ├─ dropdown.css                                           //
│  │  ├─ element-variables.css                                  //
│  │  ├─ fonts                                                  //
│  │  │  ├─ element-icons.ttf                                   //
│  │  │  └─ element-icons.woff                                  //
│  │  ├─ footer.css                                             //
│  │  ├─ form-item.css                                          //
│  │  ├─ form.css                                               //
│  │  ├─ header.css                                             //
│  │  ├─ icon.css                                               //
│  │  ├─ image.css                                              //
│  │  ├─ infinite-scroll.css                                    //
│  │  ├─ infiniteScroll.css                                     //
│  │  ├─ input-number.css                                       //
│  │  ├─ input.css                                              //
│  │  ├─ link.css                                               //
│  │  ├─ loading.css                                            //
│  │  ├─ main.css                                               //
│  │  ├─ menu-item-group.css                                    //
│  │  ├─ menu-item.css                                          //
│  │  ├─ menu.css                                               //
│  │  ├─ message-box.css                                        //
│  │  ├─ message.css                                            //
│  │  ├─ notification.css                                       //
│  │  ├─ option-group.css                                       //
│  │  ├─ option.css                                             //
│  │  ├─ page-header.css                                        //
│  │  ├─ pagination.css                                         //
│  │  ├─ popconfirm.css                                         //
│  │  ├─ popover.css                                            //
│  │  ├─ popper.css                                             //
│  │  ├─ progress.css                                           //
│  │  ├─ radio-button.css                                       //
│  │  ├─ radio-group.css                                        //
│  │  ├─ radio.css                                              //
│  │  ├─ rate.css                                               //
│  │  ├─ reset.css                                              //
│  │  ├─ row.css                                                //
│  │  ├─ scrollbar.css                                          //
│  │  ├─ select-dropdown.css                                    //
│  │  ├─ select.css                                             //
│  │  ├─ slider.css                                             //
│  │  ├─ spinner.css                                            //
│  │  ├─ step.css                                               //
│  │  ├─ steps.css                                              //
│  │  ├─ submenu.css                                            //
│  │  ├─ switch.css                                             //
│  │  ├─ tab-pane.css                                           //
│  │  ├─ table-column.css                                       //
│  │  ├─ table.css                                              //
│  │  ├─ tabs.css                                               //
│  │  ├─ tag.css                                                //
│  │  ├─ time-picker.css                                        //
│  │  ├─ time-select.css                                        //
│  │  ├─ timeline-item.css                                      //
│  │  ├─ timeline.css                                           //
│  │  ├─ tooltip.css                                            //
│  │  ├─ transfer.css                                           //
│  │  ├─ tree.css                                               //
│  │  └─ upload.css                                             //
│  ├─ utils                                                     //
│  │  ├─ api.js                                                 //
│  │  ├─ axios.js                                               //
│  │  ├─ blob.js                                                //
│  │  ├─ commonUtil.js                                          //
│  │  ├─ exportExcel.js                                         //
│  │  ├─ httpUtil.js                                            //
│  │  ├─ im.js                                                  //
│  │  ├─ tracking_code.json                                     //
│  │  └─ updateColumn.js                                        //
│  └─ views                                                     //
│     ├─ authorization.vue                                      //
│     ├─ basics                                                 //
│     │  ├─ contact.vue                                         //
│     │  ├─ countryCode.vue                                     //
│     │  ├─ currency.vue                                        //
│     │  ├─ dictionaries.vue                                    //
│     │  ├─ download.vue                                        //
│     │  ├─ Mylabel.vue                                         //
│     │  ├─ packing.vue                                         //
│     │  ├─ printing.vue                                        //
│     │  ├─ quick-navigation                                    //
│     │  │  └─ index.vue                                        //
│     │  └─ staff.vue                                           //
│     ├─ dev                                                    //
│     │  ├─ 1688.vue                                            //
│     │  ├─ brand-website.vue                                   //
│     │  ├─ facebook.vue                                        //
│     │  ├─ itemTrends.vue                                      //
│     │  ├─ plancenter.vue                                      //
│     │  └─ shopify                                             //
│     │     ├─ index.vue                                        //
│     │     └─ item-list.vue                                    //
│     ├─ emailTemplatePreview                                   //
│     │  └─ index.vue                                           //
│     ├─ error.vue                                              //
│     ├─ fba                                                    //
│     │  ├─ editOrder.vue                                       //
│     │  ├─ evaluation.vue                                      //
│     │  ├─ keyword-ranking.vue                                 //
│     │  ├─ listing.vue                                         //
│     │  ├─ PendingCherd.vue                                    //
│     │  ├─ receipt.vue                                         //
│     │  ├─ shipping-address.vue                                //
│     │  ├─ shipping-schedule.vue                               //
│     │  └─ track.vue                                           //
│     ├─ financial                                              //
│     │  ├─ accounting.vue                                      //
│     │  ├─ cashFlow.vue                                        //
│     │  ├─ custom-evaluation.vue                               //
│     │  ├─ declareCost.vue                                     //
│     │  ├─ fundAccount                                         //
│     │  │  ├─ chart.vue                                        //
│     │  │  ├─ index.vue                                        //
│     │  │  └─ swiper.vue                                       //
│     │  ├─ performanceSalary.vue                               //
│     │  ├─ punchRecord.vue                                     //
│     │  └─ refundApproval                                      //
│     │     ├─ edit.vue                                         //
│     │     └─ index.vue                                        //
│     ├─ home                                                   //
│     │  ├─ data.vue                                            //
│     │  ├─ index.vue                                           //
│     │  ├─ leaderboard.vue                                     //
│     │  └─ todo.vue                                            //
│     ├─ login.vue                                              //
│     ├─ logistics                                              //
│     │  ├─ address.vue                                         //
│     │  ├─ calculation.vue                                     //
│     │  ├─ company.vue                                         //
│     │  ├─ declare.vue                                         //
│     │  ├─ freight.vue                                         //
│     │  ├─ matching.vue                                        //
│     │  ├─ method.vue                                          //
│     │  └─ status.vue                                          //
│     ├─ market                                                 //
│     │  ├─ EDM                                                 //
│     │  │  ├─ category.vue                                     //
│     │  │  ├─ email.vue                                        //
│     │  │  ├─ formwork.vue                                     //
│     │  │  ├─ level.vue                                        //
│     │  │  ├─ manage.vue                                       //
│     │  │  └─ sendemail.vue                                    //
│     │  ├─ facebook                                            //
│     │  │  ├─ account-opening-company.vue                      //
│     │  │  ├─ account-opening-record.vue                       //
│     │  │  ├─ account-overview.vue                             //
│     │  │  ├─ account.vue                                      //
│     │  │  ├─ accountList.vue                                  //
│     │  │  ├─ adsAnalysis.vue                                  //
│     │  │  ├─ adsManager                                       //
│     │  │  │  └─ index.vue                                     //
│     │  │  ├─ agent.vue                                        //
│     │  │  ├─ application.vue                                  //
│     │  │  ├─ bm.vue                                           //
│     │  │  └─ log.vue                                          //
│     │  ├─ google                                              //
│     │  │  ├─ account.vue                                      //
│     │  │  ├─ ads.vue                                          //
│     │  │  ├─ feeds.vue                                        //
│     │  │  └─ gmc.vue                                          //
│     │  └─ portrait                                            //
│     │     ├─ log.vue                                          //
│     │     ├─ record.vue                                       //
│     │     └─ userPortrait                                     //
│     │        ├─ index.vue                                     //
│     │        ├─ item-title.vue                                //
│     │        └─ portrait.vue                                  //
│     ├─ mobile                                                 //
│     │  ├─ head.vue                                            //
│     │  ├─ home                                                //
│     │  │  ├─ announcement.vue                                 //
│     │  │  ├─ dataAnalysis.vue                                 //
│     │  │  ├─ index.vue                                        //
│     │  │  ├─ todo.vue                                         //
│     │  │  └─ top.vue                                          //
│     │  ├─ index.vue                                           //
│     │  └─ role                                                //
│     │     └─ index.vue                                        //
│     ├─ operate                                                //
│     │  ├─ asyncTask.vue                                       //
│     │  ├─ emailLog.vue                                        //
│     │  ├─ orderDownload.vue                                   //
│     │  └─ timedTask.vue                                       //
│     ├─ order                                                  //
│     │  ├─ auditpolicy.vue                                     //
│     │  ├─ components                                          //
│     │  │  ├─ add-giveaway.vue                                 //
│     │  │  ├─ check.js                                         //
│     │  │  ├─ editOrder.vue                                    //
│     │  │  ├─ exportOption.js                                  //
│     │  │  ├─ OrderSearch.vue                                  //
│     │  │  ├─ PendingCherd.vue                                 //
│     │  │  ├─ resultInfo.vue                                   //
│     │  │  ├─ table.vue                                        //
│     │  │  └─ tableComponent.vue                               //
│     │  ├─ delete.vue                                          //
│     │  ├─ delivery.vue                                        //
│     │  ├─ nodelivery.vue                                      //
│     │  ├─ nopack.vue                                          //
│     │  ├─ noplaceonfile.vue                                   //
│     │  ├─ pending.vue                                         //
│     │  ├─ placeonfile.vue                                     //
│     │  ├─ state.vue                                           //
│     │  └─ unpaid.vue                                          //
│     ├─ personalcenter                                         //
│     │  ├─ attendanceRecords.vue                               //
│     │  ├─ expense.vue                                         //
│     │  ├─ index.vue                                           //
│     │  ├─ leave.vue                                           //
│     │  ├─ performance.vue                                     //
│     │  └─ personalInformation.vue                             //
│     ├─ platform                                               //
│     │  ├─ aliExpress                                          //
│     │  │  ├─ category.vue                                     //
│     │  │  └─ manage                                           //
│     │  │     ├─ edit.vue                                      //
│     │  │     ├─ import.vue                                    //
│     │  │     ├─ index.js                                      //
│     │  │     └─ index.vue                                     //
│     │  ├─ amazon                                              //
│     │  │  ├─ site-manage                                      //
│     │  │  │  ├─ card.vue                                      //
│     │  │  │  ├─ ImgList.vue                                   //
│     │  │  │  ├─ index.vue                                     //
│     │  │  │  └─ SummaryList.vue                               //
│     │  │  └─ skuAttributeSelection.vue                        //
│     │  ├─ components                                          //
│     │  │  ├─ card-mode1.vue                                   //
│     │  │  ├─ card-shopify.vue                                 //
│     │  │  ├─ card-small-mode.vue                              //
│     │  │  ├─ import-product-temp.vue                          //
│     │  │  └─ table-mode.vue                                   //
│     │  ├─ lazza                                               //
│     │  │  └─ manage                                           //
│     │  │     ├─ index.vue                                     //
│     │  │     └─ SummaryList.vue                               //
│     │  ├─ magento                                             //
│     │  │  └─ manage                                           //
│     │  │     ├─ card-magento.vue                              //
│     │  │     ├─ edit.vue                                      //
│     │  │     ├─ index.vue                                     //
│     │  │     └─ SummaryList.vue                               //
│     │  ├─ shopify                                             //
│     │  │  ├─ manage                                           //
│     │  │  │  ├─ index.vue                                     //
│     │  │  │  └─ SummaryList.vue                               //
│     │  │  ├─ parameter.vue                                    //
│     │  │  ├─ shopifyasyn.vue                                  //
│     │  │  └─ slite-list.vue                                   //
│     │  └─ shopline                                            //
│     │     └─ manage                                           //
│     │        ├─ card-shopline.vue                             //
│     │        ├─ index.vue                                     //
│     │        └─ SummaryList.vue                               //
│     ├─ protocol.vue                                           //
│     ├─ purchase                                               //
│     │  ├─ examine.vue                                         //
│     │  ├─ lack.vue                                            //
│     │  ├─ order.vue                                           //
│     │  ├─ returned.vue                                        //
│     │  └─ warehousing.vue                                     //
│     ├─ reconciliation                                         //
│     │  ├─ advertising.vue                                     //
│     │  └─ logistics.vue                                       //
│     ├─ statistics                                             //
│     │  ├─ commodityProfit.vue                                 //
│     │  ├─ commoditySales.vue                                  //
│     │  ├─ logisticsCost.vue                                   //
│     │  ├─ orderProcessing.vue                                 //
│     │  ├─ ordersProfit.vue                                    //
│     │  ├─ orderStatus.vue                                     //
│     │  └─ storeProfits                                        //
│     │     ├─ aliexpress.vue                                   //
│     │     ├─ amazon.vue                                       //
│     │     ├─ index.vue                                        //
│     │     ├─ magento.vue                                      //
│     │     ├─ shopify-chart.vue                                //
│     │     ├─ shopify.vue                                      //
│     │     ├─ shoplazza.vue                                    //
│     │     └─ shopline.vue                                     //
│     ├─ supplier                                               //
│     │  ├─ make-temp                                           //
│     │  │  ├─ card-basic.vue                                   //
│     │  │  ├─ card-mode1.vue                                   //
│     │  │  ├─ card-small-mode.vue                              //
│     │  │  ├─ card.vue                                         //
│     │  │  ├─ edit.vue                                         //
│     │  │  ├─ import-product-temp.vue                          //
│     │  │  ├─ index.vue                                        //
│     │  │  └─ review.vue                                       //
│     │  ├─ productionManagement                                //
│     │  │  ├─ card-basic.vue                                   //
│     │  │  ├─ card-mode.vue                                    //
│     │  │  ├─ card-small-mode.vue                              //
│     │  │  ├─ card.vue                                         //
│     │  │  ├─ columns.js                                       //
│     │  │  ├─ edit.vue                                         //
│     │  │  ├─ import-product-temp.vue                          //
│     │  │  ├─ index.vue                                        //
│     │  │  ├─ review.vue                                       //
│     │  │  ├─ ship.vue                                         //
│     │  │  └─ template.js                                      //
│     │  └─ typing-rules                                        //
│     │     └─ index.vue                                        //
│     ├─ supply                                                 //
│     │  ├─ assessment.vue                                      //
│     │  ├─ category.vue                                        //
│     │  ├─ printing.vue                                        //
│     │  ├─ product                                             //
│     │  │  ├─ card-aliexpress.vue                              //
│     │  │  ├─ card-basic.vue                                   //
│     │  │  ├─ card-info-basic.vue                              //
│     │  │  ├─ card-mode.vue                                    //
│     │  │  ├─ card-shopify.vue                                 //
│     │  │  ├─ card-variants.vue                                //
│     │  │  ├─ edit.vue                                         //
│     │  │  ├─ form-aliexpress.vue                              //
│     │  │  ├─ form-basic.vue                                   //
│     │  │  ├─ form-shopify.vue                                 //
│     │  │  ├─ form-variants.vue                                //
│     │  │  ├─ index.vue                                        //
│     │  │  ├─ rightMenu.vue                                    //
│     │  │  ├─ search-form.vue                                  //
│     │  │  └─ table-mode.vue                                   //
│     │  ├─ skuManage.vue                                       //
│     │  ├─ skuquery.vue                                        //
│     │  ├─ skuSort.vue                                         //
│     │  └─ supplier.vue                                        //
│     ├─ system                                                 //
│     │  ├─ announcement.vue                                    //
│     │  ├─ functionRole                                        //
│     │  │  ├─ bus.js                                           //
│     │  │  ├─ customTabs.vue                                   //
│     │  │  ├─ index.vue                                        //
│     │  │  ├─ prview.vue                                       //
│     │  │  └─ setAuth.vue                                      //
│     │  ├─ menu.vue                                            //
│     │  ├─ numberRole.vue                                      //
│     │  ├─ operationDoc                                        //
│     │  │  └─ index.vue                                        //
│     │  ├─ settings                                            //
│     │  │  ├─ index.vue                                        //
│     │  │  ├─ information.vue                                  //
│     │  │  └─ parameter.vue                                    //
│     │  ├─ timed-task.vue                                      //
│     │  └─ users.vue                                           //
│     ├─ task                                                   //
│     │  ├─ board.vue                                           //
│     │  ├─ components                                          //
│     │  │  └─ calendar.vue                                     //
│     │  ├─ task-center                                         //
│     │  │  ├─ edit.vue                                         //
│     │  │  └─ index.vue                                        //
│     │  ├─ task-manage                                         //
│     │  │  ├─ edit.vue                                         //
│     │  │  └─ index.vue                                        //
│     │  ├─ taskPreview.vue                                     //
│     │  └─ taskTimeStandard.vue                                //
│     └─ warehouse                                              //
│        ├─ allocation.vue                                      //
│        ├─ detailed.vue                                        //
│        ├─ inventory.vue                                       //
│        ├─ manage.vue                                          //
│        ├─ otherwarehousing.vue                                //
│        ├─ outofstock.vue                                      //
│        ├─ position.vue                                        //
│        └─ warning.vue                                         //
├─ vue.config.js                                                //
└─ vue_build.sh                                                 //

```