/*
 * @Description: 描述
 * @Author: chd
 * @Date: 2020-10-17 09:42:30
 * @LastEditors: chd
 * @LastEditTime: 2021-04-28 16:07:58
 */
import { get } from '../../utils/axios'
const state = {
  menusTree: [],
  dataAccess: [],
  roleAuth: {},
  warehouselist: [],
  supplierlist: [],
}
const mutations = {
  setMenuTree(state, list) {
    state.menusTree = list
  },
  setRoleAuth(state, obj) {
    for (const key in obj) {
      state.roleAuth[key] = obj[key]
    }
  },
  setDataList(state, list) {
    state.dataAccess = list
  },

  setWarehouselist(state, list) {
    state.warehouselist = list
  },
  setSupplierList(state, list) {
    state.supplierlist = list
  },
}
const actions = {
  setMenuTree({ commit }, list) {
    commit('setMenuTree', list)
  },
  setRoleAuth({ commit }, obj) {
    commit('setRoleAuth', obj)
  },
  getWarehouselist({ commit }) {
    get('warehouseInfo/allList').then((res) => {
      commit('setWarehouselist', res.data)
    })
  },
  getSupplierList({ commit }) {
    get('supplySupplier/getCategorySupplyTree').then((res) => {
      commit('setSupplierList', res.data)
    })
  },
  getDataList({ commit, state }) {
    return new Promise((resolve) => {
      if (state.dataAccess.length === 0) {
        /* function getName(key) {
          let text = '';
          switch (key) {
            case 'order':
              text = '订单';
              break;
            case 'product':
              text = '产品';
              break;
            case 'supplier':
              text = '供应商';
              break;
            case 'customer':
              text = '客户';
              break;
          }
          return text;
        } */
        get('dataAuthority/authorityList').then((res) => {
          if (res.code === 200) {
            let obj = {}
            for (const iterator of res.data) {
              if (!obj[iterator.type]) {
                obj[iterator.type] = {
                  name: iterator.typeName,
                  children: [],
                  dataCheckAll: false,
                  dataIndeter: false,
                  dataChecklist: [],
                  group: [],
                }
              }
              const current = obj[iterator.type]
              if (iterator.propGroup) {
                const item = current.group.find(
                  (item) => item.label === iterator.propGroup
                )

                if (item) {
                  item.list.push(iterator)
                } else {
                  current.group.push({
                    label: iterator.propGroup,
                    list: [iterator],
                    checked: '',
                  })
                }
              } else {
                current.children.push(iterator)
              }
            }
            let arr = []
            for (const key in obj) {
              arr.push(obj[key])
            }
            commit('setDataList', arr)
            resolve({ dataAccess: arr, roleAuth: state.roleAuth })
          }
        })
      } else {
        resolve({ dataAccess: state.dataAccess, roleAuth: state.roleAuth })
      }
    })
  },
}
const getters = {}

export default { state, mutations, actions, getters }
