import Vue from 'vue'
import VueRouter from 'vue-router'
import Home from '../views/home.vue'
import HomePage from '../views/homePage/index.vue'
import FunctionPage from '../views/function/functionPage.vue'
import PricePage from '../views/price/pricePage.vue'
import demandPage from '../views/demand/demandPage.vue'
import aboutPage from '../views/aboutus/aboutPage'

Vue.use(VueRouter)

const routes = [
  {
    path: '/',
    name: 'home',
    component: Home,
    redirect: '/home',
    children: [
      {
        path: '/home',
        name: 'homePage',
        component: HomePage
      },
      {
        path: '/function',
        name: 'functionPage',
        component: FunctionPage,
      },
      {
        path: '/price',
        name: 'pricePage',
        component: PricePage,
      },
      {
        path: '/demand_pain_point',
        name: 'demandPage',
        component: demandPage
      },
      {
        path: '/about_us',
        name: 'aboutUs',
        component: aboutPage,
      }
    ],
  },
  {
    path: '/register',
    name: 'register',
    component: (resolve) => require(['../views/register'], resolve),
  },
  {
    path: '/login',
    name: 'login',
    component: (resolve) => require(['../views/login'], resolve),
  },
  {
    path: '/contact',
    name: 'contact',
    component: (resolve) => require(['../views/contact'], resolve),
  },
  {
    path: '/authorizationFailed',
    name: 'authorization_failed',
    component: (resolve) => require(['../views/authorization-failed'], resolve),
  },
  {
    path: '/protocol',
    name: 'protocol',
    component: (resolve) => require(['../views/protocol'], resolve),
  },
]

const router = new VueRouter({
  mode: 'history',
  routes,
})

export default router
