import Vue from 'vue'
import {
  Button,
  Form,
  FormItem,
  Input,
  Loading,
  Dropdown,
  DropdownItem,
  DropdownMenu,
  Select,
  Option,
  Avatar,
  Cascader,
  Table,
  TableColumn,
  Pagination,
  Dialog,
  Tree,
  Image,
  Checkbox,
  Switch,
  Tabs,
  TabPane,
  InputNumber,
  Row,
  Col,
  Steps,
  Step,
  Popover,
  Tooltip,
  DatePicker,
  Rate,
  Message,
  MessageBox,
  RadioGroup,
  Upload,
  Radio,
  CheckboxGroup,
  Menu,
  MenuItem,
  MenuItemGroup,
  ColorPicker,
  Autocomplete,
  Badge,
  Collapse,
  CollapseItem,
  Calendar,
  TimePicker,
  Link,
  Carousel,
  CarouselItem,
  Submenu,
  Drawer,
  Container,
  ButtonGroup,
  CascaderPanel,
  Tag,
  Scrollbar,
} from 'element-ui'

Vue.prototype.$ELEMENT = { size: 'mini' }
Vue.use(CascaderPanel)
Vue.use(Badge)
Vue.use(Menu)
Vue.use(Submenu)
Vue.use(MenuItem)
Vue.use(MenuItemGroup)
Vue.use(Image)
Vue.use(Tabs)
Vue.use(TabPane)
Vue.use(Row)
Vue.use(Col)
Vue.use(Steps)
Vue.use(Step)
Vue.use(Popover)
Vue.use(Tooltip)
Vue.use(Rate)
Vue.use(RadioGroup)
Vue.use(ColorPicker)
Vue.use(Autocomplete)
Vue.use(Collapse)
Vue.use(CollapseItem)
Vue.use(Calendar)
Vue.use(TimePicker)
Vue.use(Link)
Vue.use(Carousel)
Vue.use(CarouselItem)
Vue.use(Drawer)
Vue.use(Container)
Vue.use(ButtonGroup)
Vue.use(Tag)
Vue.use(Scrollbar)

Vue.use(Cascader)
Vue.prototype.$alert = MessageBox.alert
Vue.prototype.$message = (message) =>
  typeof message === 'string'
    ? Message({
        duration: 1000,
        message,
      })
    : Message({
        duration: 1000,
        ...message,
      })

// Vue.prototype.$message.warning = (msg)=> {

//   Message.warning({
//   duration:1000,
//   msg
// });}
Vue.prototype.$message.success = (message) =>
  typeof message === 'string'
    ? Message.success({ duration: 1000, message })
    : Message.success({ duration: 1000, ...message })
Vue.prototype.$message.warning = (message) =>
  typeof message === 'string'
    ? Message.warning({ duration: 1000, message })
    : Message.warning({ duration: 1000, ...message })
Vue.prototype.$message.info = (message) =>
  typeof message === 'string'
    ? Message.info({ duration: 1000, message })
    : Message.info({ duration: 1000, ...message })
Vue.prototype.$message.error = (message) =>
  typeof message === 'string'
    ? Message.error({ duration: 1000, message })
    : Message.error({ duration: 1000, ...message })
Vue.prototype.$msgbox = MessageBox
Vue.prototype.$confirm = MessageBox.confirm
Vue.prototype.$prompt = MessageBox.prompt
Vue.component('el-input', {
  extends: Input,
  methods: {
    handleBlur(event) {
      this.focused = false
      this.$emit('blur', event)
      if (this.validateEvent) {
        if (this.value) {
          this.value = this.value.trim()
        }
        this.$emit('input', this.value)
        this.dispatch('ElFormItem', 'el.form.blur', [this.value])
      }
    },
    // handleInput(event) {
    //   if (this.isComposing) return;
    //   if (event.target.value === this.nativeInputValue) return;
    //   let value = event.target.value
    //   if (value) {
    //     value = value.trim()
    //   }
    //   this.$emit('input', value);
    //   this.$nextTick(this.setNativeInputValue);
    // },
  },
})
Vue.use(Form)
Vue.use(Upload)
Vue.use(FormItem)
// Vue.use(Input1);
Vue.use(Select)
Vue.use(Option)
Vue.use(Avatar)
Vue.use(Button)
Vue.use(Checkbox)
Vue.use(CheckboxGroup)
Vue.use(Switch)
Vue.use(Radio)
Vue.use(InputNumber)
Vue.use(DatePicker)

Vue.use(Dropdown)
Vue.use(DropdownItem)
Vue.use(DropdownMenu)

Vue.use(Loading)
Vue.use(Dialog)
Vue.use(Tree)

Vue.use(Table)
Vue.use(TableColumn)
Vue.use(Pagination)
