<?php
namespace Sparsh\FreeShippingBar\Ui\Component\Listing\Column;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\UrlInterface;

/**
 * Class FreeShippingBarActions
 * @package Sparsh\FreeShippingBar\Ui\Component\Listing\Column
 */
class FreeShippingBarActions extends Column
{
    /**
     * Edit action path.
     */
    const SHIPPING_BAR_URL_PATH_EDIT = 'sparsh_free_shipping_bar/entity/edit';

    /**
     * Delete action path .
     */
    const SHIPPING_BAR_URL_PATH_DELETE = 'sparsh_free_shipping_bar/entity/delete';

    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    /**
     * @var string
     */
    private $editUrl;

    /**
     * FreeShippingBarActions constructor.
     *
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param array $components
     * @param array $data
     * @param string $editUrl
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        array $components = [],
        array $data = [],
        $editUrl = self::SHIPPING_BAR_URL_PATH_EDIT
    ) {
        $this->urlBuilder = $urlBuilder;
        $this->editUrl = $editUrl;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare Data Source.
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $name = $this->getData('name');
                if (isset($item['entity_id'])) {
                    $item[$name]['edit'] = [
                        'href' => $this->urlBuilder->getUrl($this->editUrl, ['entity_id' => $item['entity_id']]),
                        'label' => __('Edit')
                    ];
                    $item[$name]['delete'] = [
                        'href' => $this->urlBuilder->getUrl(
                            self::SHIPPING_BAR_URL_PATH_DELETE,
                            ['entity_id' => $item['entity_id']]
                        ),
                        'label' => __('Delete'),
                        'confirm' => [
                            'title' => __('Delete Free Shipping Bar'),
                            'message' => __('Are you sure you want to delete a Free Shipping Bar record?')
                        ]
                    ];
                }
            }
        }
        return $dataSource;
    }
}
