<?php
namespace Sparsh\FreeShippingBar\Controller\Adminhtml\Entity;

use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Driver\File;

/**
 * Class Save
 * @package Sparsh\FreeShippingBar\Controller\Adminhtml\Entity
 */
class Save extends \Sparsh\FreeShippingBar\Controller\Adminhtml\Entity implements HttpPostActionInterface
{
    /**
     * DateFilter
     *
     * @var \Magento\Framework\Stdlib\DateTime\Filter\Date
     */
    private $dateFilter;
    const FILE_DIR = 'sparsh/free_shipping_bar';


    protected $_fileUploaderFactory;

    protected $_filesystem;

    protected $_file;


    /**
     * Save constructor.
     *
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Sparsh\FreeShippingBar\Model\EntityFactory $entityFactory
     * @param \Magento\Framework\Stdlib\DateTime\Filter\Date $dateFilter
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Sparsh\FreeShippingBar\Model\EntityFactory $entityFactory,
        \Magento\Framework\Stdlib\DateTime\Filter\Date $dateFilter,
        \Magento\MediaStorage\Model\File\UploaderFactory $fileUploaderFactory,
        \Magento\Framework\Filesystem $filesystem,
        File $file

    ) {
        $this->_fileUploaderFactory = $fileUploaderFactory;
        $this->_file = $file;
        $this->_filesystem = $filesystem;
        $this->dateFilter = $dateFilter;
        parent::__construct($context, $coreRegistry, $entityFactory);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     */
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();

        if ($data) {
            try {
                if (empty($data['entity_id'])) {
                    unset($data['entity_id']);
                    $data['bar_layout_position'] = 'page_top';
                }else{
                    if ($data['entity_id'] == 2){
                        $data['bar_layout_position'] = 'insert_snippet';
                    }else{
                        $data['bar_layout_position'] = 'page_top';
                    }
                }

                /** @var $model \Sparsh\FreeShippingBar\Model\Entity */
                $model = $this->entityFactory->create();
                $entityId = (int)$this->getRequest()->getParam('entity_id');
                if ($entityId) {
                    $model->load($entityId);
                }

                if (!$data['to_date']) {
                    $data['to_date'] = null;
                }

                //pc img delete
                if (isset($data['background_img']['delete']) && $data['background_img']['delete']==1){
                    $this->deleteImg($data['background_img']['value']);
                    $data['background_img'] = '';
                }
                //phone img deletc
                if (isset($data['background_img_phone']['delete']) && $data['background_img_phone']['delete']==1){
                    $this->deleteImg($data['background_img_phone']['value']);
                    $data['background_img_phone'] = '';
                }

                //pc img upload
                if (isset($_FILES['background_img']['name']) && $_FILES['background_img']['name']){
                    $this->saveImg('background_img');
                    $data['background_img'] = '/'.self::FILE_DIR.'/'.$_FILES['background_img']['name'];
                }

                //phone img upload
                if (isset($_FILES['background_img_phone']['name']) && $_FILES['background_img_phone']['name']){
                    $this->saveImg('background_img_phone');
                    $data['background_img_phone'] = '/'.self::FILE_DIR.'/'.$_FILES['background_img_phone']['name'];
                }

                //not request img info
                if (isset($data['background_img']) && is_array($data['background_img'])){
                    //no delete and no upload new img
                    unset($data['background_img']);
                }

                if (isset($data['background_img_phone']) && is_array($data['background_img_phone'])){
                    //no delete and no upload new img
                    unset($data['background_img_phone']);
                }



                $model->setData($data);
                $model->save();

                $this->messageManager->addWarningMessage(
                    __('Please, refresh the full page cache for the changes to take effect.')
                );
                $this->messageManager->addSuccessMessage(__('The shipping bar is saved successfully.'));

                if ($this->getRequest()->getParam('back')) {
                    $this->_redirect('*/*/edit', ['entity_id' => $model->getEntityId()]);
                    return;
                }
                $this->_redirect('*/*/');
                return;
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(
                    __('Something went wrong while saving the shipping bar data. Please review the error log.')
                );
                $this->_redirect('*/*/edit', ['entity_id' => (int)$this->getRequest()->getParam('entity_id')]);
                return;
            }
            $this->_redirect('*/*/');
            return;
        }
    }

    public function saveImg($img){
        $uploader = $this->_fileUploaderFactory->create(['fileId' => $img]);
        $uploader->setAllowedExtensions(['jpg', 'jpeg', 'gif', 'png']);

        $uploader->setAllowRenameFiles(false);

        $uploader->setFilesDispersion(false);
        $path = $this->_filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath(self::FILE_DIR );

        $result = $uploader->save($path);
        return $result;
    }

    public function deleteImg($img){
        $fileName = $img;// replace this with some codes to get the $fileName
        $mediaRootDir = $this->_filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath();

        if ($this->_file->isExists($mediaRootDir . $fileName)) {
            $this->_file->deleteFile($mediaRootDir . $fileName);
            return true;
        }
        return false;
    }


}
