<?php
namespace Sparsh\FreeShippingBar\Controller\Adminhtml\Entity;

use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\ResultFactory;

/**
 * Class MassDisable
 * @package Sparsh\FreeShippingBar\Controller\Adminhtml\Entity
 */
class MassDisable extends \Sparsh\FreeShippingBar\Controller\Adminhtml\Entity implements HttpPostActionInterface
{
    /**
     * @var \Magento\Ui\Component\MassAction\Filter
     */
    protected $filter;

    /**
     * MassDisable constructor.
     *
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Sparsh\FreeShippingBar\Model\EntityFactory $entityFactory
     * @param \Magento\Ui\Component\MassAction\Filter $filter
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Sparsh\FreeShippingBar\Model\EntityFactory $entityFactory,
        \Magento\Ui\Component\MassAction\Filter $filter
    ) {
        parent::__construct($context, $coreRegistry, $entityFactory);
        $this->filter = $filter;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute()
    {
        $collection = $this->filter->getCollection($this->entityFactory->create()->getCollection());
        foreach ($collection as $item) {
            $item->setIsActive(false);
            $item->save();
        }
        try {
            $this->messageManager->addSuccess(__('A total of %1 record(s) have been disabled.', $collection->getSize()));
        } catch (\Exception $e) {
            $this->messageManager->addExceptionMessage($e, __('Something went wrong. Please try again.'));
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('*/*/');
    }
}
