<?php
namespace Sparsh\FreeShippingBar\Block\Entity;

use Magento\Store\Model\Store;
use Magento\Store\Model\StoreManagerInterface;
/**
 * Class FreeShippingBar
 * @package Sparsh\FreeShippingBar\Block\Entity
 */
class FreeShippingBar extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Sparsh\FreeShippingBar\Helper\Data
     */
    private $barDataHelper;

    protected $_store;
    /**
     * FreeShippingBar constructor.
     *
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Framework\Locale\CurrencyInterface $localeCurrency
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Sparsh\FreeShippingBar\Helper\Data $barDataHelper
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Framework\Locale\CurrencyInterface $localeCurrency,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Sparsh\FreeShippingBar\Helper\Data $barDataHelper,
        StoreManagerInterface $_store,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->_store = $_store;
        $this->localeCurrency = $localeCurrency;
        $this->storeManager = $storeManager;
        $this->barDataHelper = $barDataHelper;
    }

    /**
     * Retrieve config value.
     *
     * @return string
     */
    public function getConfig($config)
    {
        return $this->barDataHelper->getConfig($config);
    }

    /**
     * Retrieve current currency symbol.
     *
     * @return string
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getCurrentCurrencySymbol()
    {
        $currencyCode =  $this->storeManager->getStore()->getCurrentCurrencyCode();
        $currencySymbol = $this->localeCurrency->getCurrency($currencyCode)->getSymbol();
        return $currencySymbol;
    }

    /**
     * Retrieve shipping bar data.
     *
     * @return bool|mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getFreeShippingBar()
    {
        return $this->barDataHelper->getShippingBar();
    }

    /**
     * Retrieve shipping bar data by entity id.
     *
     * @param $entityId
     * @return array|bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getFreeShippingBarByEntityId($entityId)
    {
        return $this->barDataHelper->getShippingBarByEntityId($entityId);
    }


    public function getImgUrl($img){
        $mediaUrl = $this->storeManager->getStore() ->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA).$img;
        return $mediaUrl;
    }

}
