<?php

namespace Magepow\Sizechart\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Ddl\Table;

class UpgradeSchema implements UpgradeSchemaInterface
{
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $tableName = $setup->getTable('sizechart_management');
        if (version_compare($context->getVersion(), '2.0.0', '<')) {
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                $connection = $setup->getConnection();
                $connection->addColumn(
                    $setup->getTable($tableName),
                    'template_css',
                    [
                        'type' => Table::TYPE_TEXT,
                        'length' => '2M',
                        'nullable' => true,
                        'comment' => 'template css'
                    ]
                );
            }
        }

        if (version_compare($context->getVersion(), '2.3.0', '<')) {
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                $connection = $setup->getConnection();
                $connection->addColumn(
                    $setup->getTable($tableName),
                    'stores',
                    [
                        'type' => Table::TYPE_TEXT,
                        'length' => '2M',
                        'nullable' => false,
                        'comment' => 'Store Views'
                    ]
                );
            }
        }
        if (version_compare($context->getVersion(), '2.5.2', '<')) {
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                $connection = $setup->getConnection();
                $connection->addColumn(
                    $setup->getTable($tableName),
                    'custom_size',
                    [
                        'type' => Table::TYPE_TEXT,
                        'nullable' => false,
                        'comment' => 'custom size'
                    ]
                );

                $connection->addColumn(
                    $setup->getTable($tableName),
                    'column_label',
                    [
                        'type' => Table::TYPE_TEXT,
                        'nullable' => false,
                        'comment' => 'column label'
                    ]
                );
            }
        }

    }
}