<?php

namespace Magepow\Sizechart\Model;

use Magento\Framework\Data\OptionSourceInterface;

class TypeDisplay implements OptionSourceInterface
{

    public function getOptionArray()
    {
        $options = ['1' => __('Inline'), '2' => __('Pop Up'), '3' => __('Custom Tab')];
        return $options;
    }

    /**
     * Get Grid row status labels array with empty value for option element.
     *
     * @return array
     */
    public function getAllOptions()
    {
        $res = $this->getOptions();
        array_unshift($res, ['value' => '', 'label' => '']);
        return $res;
    }

    /**
     * Get Grid row type array for option element.
     * @return array
     */
    public function getOptions()
    {
        $res = [];
        foreach ($this->getOptionArray() as $index => $value) {
            $res[] = ['value' => $index, 'label' => $value];
        }
        return $res;
    }

    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return $this->getOptions();
    }
}