<?php

namespace Magepow\Sizechart\Block\Adminhtml\Sizechart\Edit\Tab;

use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magepow\Sizechart\Block\Adminhtml\Sizechart\ChartTable;
use Magepow\Sizechart\Block\Adminhtml\Sizechart\CustomerSize;
use Magepow\Sizechart\Block\Adminhtml\Sizechart\Field\FieldChartTable;
use Magepow\Sizechart\Block\Adminhtml\Sizechart\Field\FieldColumnLabel;

class Main extends Generic implements TabInterface
{
    protected $_systemStore;
    protected $_objectManager;
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Cms\Model\Wysiwyg\Config $wysiwygConfig,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Framework\ObjectManagerInterface $objectManager,
        \Magepow\Sizechart\Model\Status $options,
        \Magento\Store\Model\System\Store $systemStore,
        \Magepow\Sizechart\Model\TypeDisplay $typeDisplay,
        array $data = []
    ) {

        $this->_systemStore = $systemStore;
        $this->_options = $options;
        $this->_wysiwygConfig = $wysiwygConfig;
        $this->_typeDisplay = $typeDisplay;
        $this->_systemStore = $systemStore;
        $this->_objectManager = $context->getStoreManager();

        parent::__construct($context, $registry, $formFactory, $data);
    }
    protected function _prepareForm()

    {
        $dateFormat = $this->_localeDate->getDateFormat(\IntlDateFormatter::SHORT);
        $model = $this->_coreRegistry->registry('row_data');
        $form = $this->_formFactory->create();
        $form->setHtmlIdPrefix('wkgrid_');
        if ($model->getEntityId()) {
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Edit Size Chart Rule'), 'class' => 'fieldset-wide']
            );
            // $fieldset->addField('entity_id', 'hidden', ['name' => 'entity_id']); // not use will conflict entity_id ofcondition product
            $fieldset->addField('sizechart_id', 'hidden', ['name' => 'sizechart_id']);
        } else {
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Add Size Chart Rule'), 'class' => 'fieldset-wide']
            );
        }

        $fieldset->addField(
            'name',
            'text',
            [
                'name' => 'name',
                'label' => __('Name'),
                'id' => 'name',
                'title' => __('Name'),
                'class' => 'required_entry',
                'required' => true,
            ]
        );

        if (!$this->_storeManager->isSingleStoreMode()) {
            $field = $fieldset->addField(
                'stores',
                'multiselect',
                [
                    'name' => 'stores[]',
                    'label' => __('Store View'),
                    'title' => __('Store View'),
                    'required' => true,
                    'values' => $this->_systemStore->getStoreValuesForForm(false, true)
                ]
            );
            $renderer = $this->getLayout()->createBlock(
                'Magento\Backend\Block\Store\Switcher\Form\Renderer\Fieldset\Element'
            );
            $field->setRenderer($renderer);
        } else {
            $fieldset->addField(
                'stores',
                'hidden',
                ['name' => 'stores[]', 'value' => $this->_storeManager->getStore(true)->getId()]
            );
            $model->setStoreId($this->_storeManager->getStore(true)->getId());
        }

        $fieldset->addField(
            'description',
            'textarea',
            [
                'name' => 'description',
                'label' => __('Description'),
                'id' => 'description',
                'title' => __('Description'),
                'style' => 'height:10em',
                'required' => false,
            ]
        );

        $wysiwygConfig = $this->_wysiwygConfig->getConfig(['tab_id' => $this->getTabId()]);
        $fieldset->addField(
            'sizechart_info',
            'editor',
            [
                'name' => 'sizechart_info',
                'label' => __('Size Chart Information'),
                'wysiwyg' => true,
                'required' => true,
                'config' => $wysiwygConfig
            ]
        );

        $fieldset->addType(
            'column_label',
            FieldColumnLabel::class
        );

        $fieldset->addType(
            'chart_table',
            FieldChartTable::class
        );

        $fieldset->addField(
            'column_label',
            'column_label',
            [
                'name' => 'column_label',
                'label' => __('Column Label'),
                'id' => 'column_label',
                'title' => __('Column Label'),
                'required' => true,
            ]
        );

        $fieldset->addField(
            'chart_table',
            'chart_table',
            [
                'name' => 'chart_table',
                'label' => __('Chart Table(英尺,范围值用-分隔)'),
                'id' => 'chart_table',
                'title' => __('Chart Table'),
                'required' => false,
            ]
        );

        $fieldset->addField(
            'category',
            'text',
            [
                'name' => 'category',
                'label' => __('分类ID(多个用,隔开不要空格)'),
                'id' => 'category',
                'title' => __('分类ID(多个用,隔开不要空格)'),
                'required' => false,
            ]
        );

        $fieldset->addField(
            'type_display',
            'hidden',
            [
                'name' => 'type_display',
                'label' => __('Type Display'),
                'id' => 'type_display',
                'title' => __('Type Display'),
                'value' =>  1,
                'required' => false,
            ]
        );

        $fieldset->addField(
            'is_active',
            'select',
            [
                'name' => 'is_active',
                'label' => __('Status'),
                'id' => 'is_active',
                'title' => __('Status'),
                'values' => $this->_options->getOptionArray(),
                'value' => 1,
                'required' => true,
            ]
        );

        $form->addValues($model->getData());
        $this->setForm($form);

        return parent::_prepareForm();
    }

    public function getTabLabel()
    {
        return __('General Information');
    }

    public function getTabTitle()
    {
        return __('General Information');
    }

    /**
     * Can show tab in tabs
     *
     * @return boolean
     * @api
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * Tab is hidden
     *
     * @return boolean
     * @api
     */
    public function isHidden()
    {
        return false;
    }
}