<?php

namespace Magepow\Sizechart\Block\Adminhtml\Sizechart;

use Joshine\Review\Model\Repository\VoteRepository;
use Magento\Framework\View\Element\Template;
use Magepow\Sizechart\Model\SizechartFactory;

class ChartTable extends Template
{
    protected $_template = 'Magepow_Sizechart::chartTable.phtml';

    /**
     * @var SizechartFactory
     */
    private $chartFactory;

    public function __construct(
        Template\Context $context,
        SizechartFactory $chartFactory,
        array $data = []
    ) {
        $this->chartFactory = $chartFactory;
        parent::__construct($context, $data);
    }

    public function getCustomSizeData()
    {
        $id  = $this->getRequest()->getParam('id');
        if (!$id) {
            return [];
        }
        return $this->chartFactory->create()->load($id);
    }
}