<?php
namespace Magento\Directory\Model\ResourceModel\Country;

class CollectionNew
{
    protected $scopeConfig;

    public function __construct(\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function afterToOptionArray(\Magento\Directory\Model\ResourceModel\Country\Collection $subject, $result) {
        if (!is_array($result) || empty($result)) {
            return $result;
        }
        $topCountry = $this->scopeConfig->getValue('system/top_country/top_countrys');
        if (!$topCountry) {
            return $result;
        }
        if (!$result[0]['value']) {
            unset($result[0]);
        }
        $topCountry = explode(',', $topCountry);
        $indexs = array_flip($topCountry);
        $top = [];
        $top[0] = ['value' => '', 'label' => ''];
        foreach ($result as $row) {
            if (in_array($row['value'], $topCountry)) {
                $idx = $indexs[$row['value']] + 1;
                $top[$idx] = $row;
            }
        }
        ksort($top);
        $top[] = ['value' => '-', 'label' => '---'];
        $result = array_merge($top, $result);
        return $result;
    }
}