/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'Magento_Checkout/js/view/summary/abstract-total',
    'Magento_Checkout/js/model/quote'
], function ($, Component,quote) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Magento_Checkout/placeorder'
        },
        totals: quote.getTotals(),
        placeOrder:function(){
            if($('#checkout-step-shipping').is(":visible"))
            {
                return false;
            }
            $('.checkout-index-index .payment-method._active').find('.actions-toolbar').find('button').trigger('click');
        }
        ,
        getTotalPrice:function(){
            return this.getFormattedPrice(this.totals().grand_total);
        }
    });
});

