/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'uiComponent',
    'Magento_Ui/js/modal/alert',
    'mage/mage',

], function ($, Component, modalAlert) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Magento_Checkout/checkout-index-footer'
        },
        initialize: function () {
            this.initStep();
            this._super();
            return this;
        },
        initStep: function () {
            $(document).on('click','.cf-link',function(){
                var dataKey = $(this).attr('data-key');
                if(!dataKey)
                {
                    return false;
                }
                $.ajax({
                    url: '/cms/index/getPage',
                    type: 'POST',
                    data: {'identifier':dataKey},
                    dataType: 'json',
                    success: function (result) {
                        modalAlert({
                            title: result.title,
                            content: result.content,
                            button:[]
                        });
                    }
                });
            });
        }
    });
});
