<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\Catalog\Controller\Product;
use Magento\Framework\App\Action\Context;

class Recently extends \Magento\Framework\App\Action\Action
{
    protected $_objectManager;

    public function __construct(
        \Magento\Framework\ObjectManagerInterface $objectManager,
        Context $context
    ) {
        $this->_objectManager = $objectManager;
        parent::__construct($context);
    }

    public function execute()
    {
        $result = ['status' => 'fail'];
        $request = $this->getRequest();
        if ($request->isPost() && $request->isAjax()) {
            $productIds = $request->getParam('ids');
            if (substr($productIds, -1) == ',') {
                $productIds = substr($productIds, 0, -1);
            }
            $in = explode(',', $productIds);

            /** @var \Magento\Catalog\Model\ResourceModel\Product\Collection $productCollection */
            $productCollection = $this->_objectManager->get('Magento\Catalog\Model\ResourceModel\Product\Collection');
            $productCollection->addAttributeToSelect('*')
                ->addFieldToFilter('status', 1)
                ->addAttributeToFilter('entity_id', array( 'in' => $in));
            $productCollection->getSelect()->order(sprintf("field(e.entity_id,%s)", $productIds))->limit(6);
            /** @var \Magento\CatalogInventory\Helper\Stock $stockHelper */
            $stockHelper = $this->_objectManager->get('Magento\CatalogInventory\Helper\Stock');
            $stockHelper->addInStockFilterToCollection($productCollection);
            if (count($productCollection) > 0) {
                $result['status'] = 'success';
                /** @var Magento\Catalog\Block\ListProduct $block */
                $block = $this->_view->getLayout()->createBlock('Magento\Catalog\Block\ListProduct');
                $block->setProducts($productCollection);
                $block->setType('recently');
                $block->setTemplate('Magento_Catalog::product/list-new.phtml');
                $result['html'] = $block->toHtml();
            }
        }

        return $this->getResponse()->representJson(json_encode($result));
    }
}