<?php

namespace Joshine\Script\Console\Command;

use Google\Service\BinaryAuthorization\ValidateAttestationOccurrenceRequest;
use Joshine\InstagramFeed\Block\MediaFeed;
use Joshine\InstagramFeed\Model\Cache\Type;
use Joshine\Review\Helper\ImageHelper;
use Joshine\Review\Model\ImageUploader;
use Magento\Framework\App\Area;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\App\State;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\File\Csv;
use Magento\Framework\ObjectManager\ObjectManager;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Serialize\Serializer\Json;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\BlockFactory;
use Magento\Setup\Exception;
use Magento\Store\Model\App\Emulation;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManager;
use Magento\Store\Model\StoreManagerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

use Magento\Review\Model\Review;

use Magento\Customer\Model\Customer;
use Magento\Customer\Model\ResourceModel\Customer\CollectionFactory;
class InstagramFeedPull extends Command
{

    const IMAGE_PATH = '/joshine/instagram/';
    const IMAGE_TMP_PATH = '/joshine/instagram/tmp/';

    /**
     * @var Csv
     */
    private $csv;
    /**
     * @var Customer
     */
    private $customer;
    /**
     * @var DirectoryList
     */
    private $directoryList;
    /**
     * @var ResourceConnection
     */
    private $resource;
    /**
     * @var AdapterInterface
     */
    private $connection;
    /**
     * @var State
     */
    private $state;
    /**
     * @var Magento\Customer\Model\ResourceModel\Customer\Collection
     */
    private $collection;
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    const   FILE = "csv";

    /**
     * @var OutputInterface
     */
    private $_output;
    /**
     * @var mixed
     */
    private $storeId;
    /**
     * @var ImageUploader
     */
    private $imageUploader;
    /**
     * @var \Joshine\Review\Model\ImagesFactory
     */
    private $imagesFactory;
    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    private $messageManager;
    /**
     * @var \Joshine\Review\Model\ResourceModel\Images
     */
    private $imagesResource;
    /**
     * @var \Magento\Framework\Filesystem
     */
    private $filesystem;
    /**
     * @var \Magento\Framework\Filesystem\Io\File
     */
    private $ioFile;
    /**
     * @var MediaFeed
     */

    const INSTAGRAM_API_BASE_URL = 'https://api.instagram.com';

    const INSTAGRAM_GRAPH_API_URL = "https://graph.instagram.com";

    const INSTAGRAM_AUTH_URL  = 'oauth/authorize';

    const INSTAGRAM_TOKEN_URL = 'oauth/access_token';

    const REDIRECT_URL = 'admin/joshine_instagram/oauth/redirect';

    protected $_objectManager;
    /**
     * @var \Magento\Framework\HTTP\Client\Curl
     */
    private $_curlClient;
    /**
     * @var \Magento\Framework\Json\EncoderInterface
     */
    private $jsonEncoder;
    /**
     * @var Json
     */
    private $_json;
    /**
     * @var \Magento\Framework\Json\Decoder
     */
    private $jsonDecoder;
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var \Magento\Framework\App\Cache\StateInterface|mixed
     */
    private $_cacheState;
    /**
     * @var \Magento\Framework\Image\AdapterFactory
     */
    private $imageFactory;
    /**
     * @var \Magento\Framework\Filesystem\Io\File
     */
    private $fileManager;
    /**
     * @var string
     */
    private $id;
    /**
     * @var \Magento\Framework\App\CacheInterface
     */
    private $_cache;

    public function __construct(
        \Magento\Framework\Filesystem $filesystem,
        ObjectManager      $objectManager,
        CollectionFactory  $collectionFactory,
        Csv                $csv,
        Customer           $customer,
        DirectoryList      $directoryList,
        ResourceConnection $resource,
        State              $state,
        \Magento\Framework\Filesystem\Io\File $fileManager,
        \Magento\Framework\Image\AdapterFactory $imageFactory,
        \Magento\Framework\Filesystem\Io\File $ioFile,
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Framework\HTTP\Client\Curl $curl,
        \Magento\Framework\Json\EncoderInterface $jsonEncoder,
        \Magento\Framework\App\CacheInterface $cache,
        \Magento\Framework\Json\Decoder $jsonDecoder,
        StoreManagerInterface $storeManager,
        \Magento\Framework\App\Cache\StateInterface $_cacheState,
        ImageUploader $imageUploader,
        \Joshine\Review\Model\ImagesFactory $imagesFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Joshine\Review\Model\ResourceModel\Images $imagesResource,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        string             $name = null
    )
    {
        parent::__construct($name);
        $this->imageFactory    = $imageFactory;
        $this->fileManager     = $fileManager;
        $this->_objectManager    = $objectManager;
        $this->imageUploader     = $imageUploader;
        $this->storeManager      = $storeManager;
        $this->_cacheState      = $_cacheState;
        $this->_cache            = $cache;
        $this->jsonDecoder      = $jsonDecoder;
        $this->filesystem        = $filesystem;
        $this->scopeConfig      = $scopeConfig;
        $this->imagesFactory     = $imagesFactory;
        $this->messageManager    = $messageManager;
        $this->_curlClient       = $curl;
        $this->imagesResource    = $imagesResource;
        $this->collectionFactory = $collectionFactory;
        $this->directoryList     = $directoryList;
        $this->state             = $state;
        $this->ioFile            = $ioFile;
    }

    protected function configure()
    {
        $this->setName('joshine:instagram-pull');
        $this->setDescription('拉取ins媒体');
        $this->addOption(
            "store_id",
            null,
            InputOption::VALUE_REQUIRED,
            'store id'
        );
        parent::configure();
    }

    public function getBaseURL()
    {
        return $this->storeManager->getStore($this->storeId)->getBaseUrl();
    }

    protected function execute(
        InputInterface  $input,
        OutputInterface $output
    )
    {
        $base_path = str_replace( '\\' , '/' , realpath(dirname(__FILE__).'/../../../../../../'));
        $base_path .= "/pub/";

        $this->id = $this->getId();
        $storeId = $input->getOption('store_id');
        if (!$storeId) {
            $output->writeln("[error]store_id没填");
            return;
        }
        $this->storeId = $storeId;
        $raw = $this->getMediaByApi();
        if (!isset($raw['data'])) {
            return;
        }
        $media = $raw['data'];

        foreach ($media as $index => $row) {
            $url = $row["thumbnail_url"] ?? $row["media_url"];
            $key = isset($row['thumbnail_url']) ? 'thumbnail_url' : 'media_url';
            $res = $this->downloadImage($url);
            $path = $this->resize($res);

            $res =  str_replace($base_path,"", $path);
            $media[$index][$key] = $res;
        }

        $media = array_merge($media, []);
        $arr = [];
        $arr['data'] = $media;
        $this->flushCache(json_encode($arr, true));
        return;
    }

    public function downloadImage($url)
    {
        $path = $this->directoryList->getPath('var');
        $file = $path.DIRECTORY_SEPARATOR.mt_rand(10000,99999).time().md5($url).".jpeg";
        @file_put_contents($file,file_get_contents($url));
        return $file;
    }


    public function flushCache($media)
    {
        $this->cacheFeed($media);
    }


    public function getConfig($path, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }

    public function getAppid()
    {
        return $this->getConfig('joshine_instagram_feed/general/appid', $this->storeId);
    }


    public function getAppSecret()
    {
        $this->getConfig('joshine_instagram_feed/general/app_secret', $this->storeId);
    }

    public function redirectUri() :string
    {
        return $this->getBaseUrl().self::REDIRECT_URL;
    }
    public function authUrl() : string
    {
        return self::INSTAGRAM_API_BASE_URL.'/'
            .self::INSTAGRAM_AUTH_URL.
            "?client_id={$this->getAppid()}&redirect_uri={$this->redirectUri()}&scope=user_profile,user_media&response_type=code";
    }

    public function getMediaUrl($token, $uid): string
    {
        return self::INSTAGRAM_GRAPH_API_URL."/v16.0/{$uid}/media?access_token={$token}&fields=caption,id,is_shared_to_feed,media_type,media_url,permalink,thumbnail_url,timestamp,username&limit=12";
    }

    public function getMediaByApi()
    {
        $uid = $this->getConfig('joshine_instagram_feed/general/user_id', $this->storeId);
        $token = $this->getConfig('joshine_instagram_feed/general/access_token', $this->storeId);

        $url = $this->getMediaUrl($token, $uid);

        try {
            $this->getCurlClient()->get($url);
            $this->getCurlClient()
                ->setOptions([
                    CURLOPT_SSL_VERIFYHOST => false,
                    CURLOPT_SSL_VERIFYPEER => false
                ]);
            if ($this->getCurlClient()->getStatus() != 200) {
                return [];
            }
        } catch (\Exception $e) {
            echo $e->getMessage();
            return [];
        }
        return $this->jsonDecoder->decode($this->getCurlClient()->getBody());
    }

    public function getCurlClient()
    {
        return $this->_curlClient;
    }

    public function getId()
    {
        try {
            return base64_encode($this->storeManager->getStore($this->storeId)->getCode() . Type::TYPE_IDENTIFIER);
        } catch (NoSuchEntityException $e) {
            return base64_encode(date('Y-m-d') . Type::TYPE_IDENTIFIER);
        }
    }

    public function cacheFeed($feed)
    {
        if ($this->_cacheState->isEnabled(Type::TYPE_IDENTIFIER)) {
            $this->save($feed, $this->id);
        }
        return true;
    }

    public function save($data, $cacheId)
    {
        if ($this->_cacheState->isEnabled(Type::TYPE_IDENTIFIER)) {
            return $this->_cache->save($data, $cacheId, [Type::CACHE_TAG], Type::CACHE_LIFETIME);
        }

        return false;
    }

    public function copy(string $imagePath)
    {
        $from = $imagePath;
        $fileName = basename($imagePath);
        if ($this->ioFile->fileExists($from)) {
            $realPath = $this->filesystem->getDirectoryRead(
                DirectoryList::MEDIA
            )->getAbsolutePath(
                ImageHelper::IMAGE_PATH
            );
            $counter = 0;
            while ($this->ioFile->fileExists($realPath . $fileName)) {
                $imagePathArray = explode('.', $fileName);
                $imagePathArray[0] .= $counter++;
                $fileName = implode('.', $imagePathArray);
            }
            $this->ioFile->checkAndCreateFolder($this->ioFile->dirname($realPath . $fileName));
            if ($this->ioFile->mv($from, $realPath . $fileName)) {
                return  '/'.basename($fileName);
            }
        }

        return false;
    }

    public function resize($image, $width = 600, $height = 600)
    {
        $absolutePath = $image;

        $imageResized = $this->filesystem->getDirectoryRead(DirectoryList::MEDIA)
                ->getAbsolutePath(self::IMAGE_PATH . 'resized/' . $width . '/')
            . basename($image);

        if ($this->fileManager->fileExists($imageResized)) {
            return $imageResized;
        }
        if (!$this->fileManager->fileExists($absolutePath)) {
            return "";
        }

        //create image factory...
        $imageResize = $this->imageFactory->create();
        $imageResize->open($absolutePath);
        $imageResize->constrainOnly(true);
        $imageResize->keepTransparency(true);
        $imageResize->keepFrame(false);
        $imageResize->backgroundColor([255, 255, 255]);
        $imageResize->keepAspectRatio(true);
        $imageResize->resize($width, $height);

        $destination = $imageResized;
        $imageResize->save($destination);
        return $destination;
    }

}