<?php

namespace Joshine\Review\Plugin\Review\Block;

use Magento\Review\Block\Form as MagentoForm;

class Form
{

    /**
     * @var \Joshine\Review\Helper\BlockHelper
     */
    private $blockHelper;

    public function __construct(
        \Joshine\Review\Helper\BlockHelper $blockHelper
    ) {
        $this->blockHelper = $blockHelper;
    }

    public function afterToHtml(
        MagentoForm $subject,
        $result
    ) {
        $search = '</fieldset>';
        $replace = $this->getImageUploadHtml() . $search;
        $result = substr_replace($result, $replace, strrpos($result, $search), strlen($search));

        $searchForm = 'data-role="product-review-form"';
        return str_replace($searchForm, $searchForm . ' enctype="multipart/form-data" ', $result);
    }

    protected function getImageUploadHtml(): string
    {
        return sprintf(
            '<div class="field review-field-image %s">
                <label class="label">%s</label><div class="control">
                <input class="joshine-input" name="review_images[]" accept="image/*" multiple %s type="file" title="%s">
                </div></div>',
            '',
            __('Add your photo'),
            '',
            __('Add your photo')
        );
    }
}