<?php

namespace Joshine\CouponPusher\Model\Strategy;

use Joshine\CouponPusher\Block\CouponSubscribeAlert;
use Joshine\CouponPusher\Helper\Constant;
use Joshine\CouponPusher\Helper\CustomerChecker;

class SubscribePushStrategy implements ContractPushStrategy
{
    /**
     * @var \Magento\Framework\View\Element\BlockFactory
     */
    private $blockFactory;

    private $customerChecker;

    public function __construct(
        \Magento\Framework\View\Element\BlockFactory $blockFactory,
        CustomerChecker $customerChecker
    )
    {
        $this->blockFactory = $blockFactory;
        $this->customerChecker = $customerChecker;
    }


    public function push()
    {
        //停推10分钟
        $this->stopPushTerm();
        return $this->blockFactory->createBlock(CouponSubscribeAlert::class)->toHtml();
    }

    public function stopPushTerm()
    {
        $this->customerChecker->setCookie(Constant::STOP_COUPON_PUSH, 'true', 60 * 10);
    }
}