<?php
namespace Joshine\CouponPusher\Helper;


class CustomerChecker implements \Magento\Framework\Data\CollectionDataSourceInterface
{

    protected $_cookieManager;

    protected $_dateTime;

    protected $_cookieMetadataFactory;

    private   $_request;

    public function __construct(
        \Magento\Framework\Stdlib\DateTime\DateTime $dateTime,
        \Magento\Framework\Stdlib\CookieManagerInterface $cookieManager,
        \Magento\Framework\Stdlib\Cookie\CookieMetadataFactory $cookieMetadataFactory,
        \Magento\Framework\App\RequestInterface $request
    )
    {
        $this->_cookieManager         = $cookieManager;
        $this->_cookieMetadataFactory = $cookieMetadataFactory;
        $this->_dateTime              = $dateTime;
        $this->_request               = $request;
    }

    public function checkFirstVisit(): bool
    {
        return is_null($this->_cookieManager->getCookie(Constant::HAS_VISITED_COOKIE_KEY));
    }

    public function setFirstVisitCookie()
    {
        $this->setCookie(Constant::HAS_VISITED_COOKIE_KEY, 'true', Constant::HAS_VISITED_COOKIE_DURATION);
    }


    public function checkSubscribed(): bool
    {
        return !is_null($this->_cookieManager->getCookie(Constant::HAS_SUBSCRIBE));
    }

    public function setSubscribeCookie()
    {
        $this->setCookie(Constant::HAS_SUBSCRIBE, 'true', Constant::HAS_SUBSCRIBE_COOKIE_DURATION);
    }

    public function setCookie($key, $data, $time)
    {
        $metadata = $this->_cookieMetadataFactory
            ->createPublicCookieMetadata()
            ->setPath('/')
            ->setDuration($time);
        $this->_cookieManager->setPublicCookie(
            $key,
            $data,
            $metadata
        );
    }

    //访客细分
    public function getCustomerSegments(): string
    {
        if ($this->checkFirstVisit()) {
            $this->setFirstVisitCookie();
            return Constant::FIRST_VISITOR;
        }

        if (!$this->checkSubscribed()) {
            return Constant::NOT_SUBSCRIBE;
        }

        if ($this->checkSubscribed()) {
            return Constant::HAS_SUBSCRIBE;
        }

        return Constant::OTHER;
    }
}
