<?php
namespace Joshine\Category\Setup;

use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

class InstallData implements InstallDataInterface
{
    private $eavSetupFactory;

    public function __construct(EavSetupFactory $eavSetupFactory)
    {
        $this->eavSetupFactory = $eavSetupFactory;
    }

    public function install(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    )
    {
        $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);
        $eavSetup->addAttributeGroup(
            \Magento\Catalog\Model\Category::ENTITY,
            $eavSetup->getDefaultAttributeSetId(\Magento\Catalog\Model\Category::ENTITY),
            'Custom Menu',
            99
        );
        $eavSetup->addAttribute(
            \Magento\Catalog\Model\Category::ENTITY,
            'badge',
            [
                'type'         => 'varchar',
                'label'        => 'badge',
                'input'        => 'select',
                'sort_order'   => 100,
                'source'       => '\Joshine\Category\Model\Category\Attribute\Source\Badge',
                'global'       => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                'visible_on_front'  => true,
                'required'     => false,
                'user_defined' => false,
                'default'      => null,
                'group'        => 'Custom Menu',
                'backend'      => ''
            ]
        );
    }
}
