<?php

namespace Joshine\Category\Observer\Frontend\Catalog;
use Magento\Framework\Url;
use Magento\Framework\UrlInterface;
class CategoryLoadAfter implements \Magento\Framework\Event\ObserverInterface
{

    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;

    private $url;

    private $attributeRepository;
    public function __construct(
        \Psr\Log\LoggerInterface $logger,
        UrlInterface $url,
        \Magento\Eav\Api\AttributeRepositoryInterface $attributeRepository
    )
    {

        $this->logger = $logger;
        $this->url = $url;
        $this->attributeRepository = $attributeRepository;
    }

    /**
     * Execute observer
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(
        \Magento\Framework\Event\Observer $observer
    )
    {
        $category = $observer->getEvent()->getCategory();
        if ($category instanceof \Magento\Catalog\Model\Category) {
            $url =  ltrim(parse_url($this->url->getBaseUrl())['host'],'www.');
            $str = $this->getUrlParameter($category);
            $oldMetaDescription = $category->getMetaDescription();
            $oldMetaKeyword = $category->getMetaKeywords();
            $category->setMetaTitle(__('Buy the Latest').' '. $str['title'] .__(' on ').$url);
            $category->setMetaDescription(__('Shop ') . $str['title'] . '. ' . $oldMetaDescription);
            if ($str['keyword'] && $str['keyword'] != '.'){
                $category->setMetaKeywords($str['keyword']);
            }else{
                $category->setMetaKeywords($oldMetaKeyword);
            }
        }
    }

    public function getUrlParameter($category){

        $categoryName = $category->getName();
        $data = $_REQUEST;
        $arr = ['title'=>'' , 'keyword'=>''];
        if (isset($data['product_list_order'])){
            $sortBy = $category->getAvailableSortByOptions();
            $arr['title']   .=  __($sortBy[$data['product_list_order']])   . ' ';
            $arr['keyword'] .=  __($sortBy[$data['product_list_order']]) .' '. $categoryName.',';
        }

        if (isset($data['color'])){
            $attribute = $this->attributeRepository->get('4', 'color');
            $optionText = $attribute->getSource()->getOptionText($data['color']);
            $arr['title'] .= $optionText .' ';
            $arr['keyword'] .= $optionText .' '. $categoryName .',';
        }

        if (isset($data['size'])){
            $attribute = $this->attributeRepository->get('4', 'size');
            $optionText = $attribute->getSource()->getOptionText($data['size']);
            $arr['title'] .= $optionText .' ';
            $arr['keyword'] .= $optionText .' '. $categoryName .',';
        }

        if (isset($data['price'])){
           $priceArr = explode('-',$data['price']);
           $price = '$'.$priceArr[0].'-$'.$priceArr[1];
            $arr['title'] .= $price .' ';
            $arr['keyword'] .= $price .' '. $categoryName.',';
        }
        $arr['title'] .= $categoryName;
        $arr['keyword'] = rtrim($arr['keyword'],',') . '.';

        return $arr;
    }
}