<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Joshine\Catalog\Helper;

use Magento\Catalog\Helper\Image;
use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\Product\Gallery\ReadHandler as GalleryReadHandler;
use Magento\Framework\App\Helper\Context;

/**
 * Catalog data helper
 *
 * @api
 *
 * @SuppressWarnings(PHPMD.TooManyFields)
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 * @since 100.0.2
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{

    protected $galleryReadHandler;
    /**
     * Catalog Image Helper
     *
     * @var \Magento\Catalog\Helper\Image
     */
    protected $imageHelper;

    public function __construct(
        GalleryReadHandler $galleryReadHandler, Context $context, Image $imageHelper)
    {
        $this->galleryReadHandler = $galleryReadHandler;
        $this->imageHelper        = $imageHelper;
        parent::__construct($context);
    }


    public function getSecondProductImage(Product $product){
        $this->galleryReadHandler->execute($product);
        $images = $product->getMediaGalleryImages();
        if(count($images)>=2){
            $index = 0;
            foreach ($images as $image) {
                $index++;
                if($index==2){
                    $image->setData(
                        'second_image',
                        $this->imageHelper->init($product, 'category_page_list')
                        ->constrainOnly(true)->keepAspectRatio(true)->keepFrame(false)
                            ->setImageFile($image->getFile())
                            ->getUrl()
                    );
                    $result = $image;
                    break;
                }
            }
            return $result;
        }else{
            return null;
        }

    }
}
