<?php
namespace  Joshine\Banner\UiForm\Model;


use Magento\Ui\DataProvider\AbstractDataProvider;
use Magento\Framework\App\RequestInterface;
use Joshine\Banner\Model\ResourceModel\Bass\CollectionFactory;
use Magento\Store\Model\StoreManagerInterface;

class DataProvider extends AbstractDataProvider
{

    protected $_request;

    protected $collection;

    protected $loadedData;

    protected $storeManager;

    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        array $meta = [],
        array $data = [],
        RequestInterface $request,
        CollectionFactory $collectionFactory,
        StoreManagerInterface $storeManager
    )
    {
        $this->storeManager = $storeManager;
        $this->collection = $collectionFactory->create();
        $this->_request = $request;
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }


    public function getData()
    {
        if (isset($this->loadedData)) {

            return $this->loadedData;
        }

        $id = $this->_request->getParam('id');

        $items = $this->collection->getItems();

        foreach ($items as $item) {
            $this->loadedData[$item->getId()] = $item->getData();
            $m['active'] = $item->getStatus();

            $imgPatch = $item->getImgPatch();
            if ($imgPatch) {
                $m['pcImage'][0]['name'] = $this->getFileName($imgPatch);
                $m['pcImage'][0]['url'] = $this->getMediaUrl($imgPatch);
                $m['pcImage'][0]['type'] = 'image';
            }
            $phoneImg = $item->getPhoneImgPatch();
            if ($phoneImg){
                $m['phoneImage'][0]['name'] = $this->getFileName($phoneImg);
                $m['phoneImage'][0]['url'] = $this->getMediaUrl($phoneImg);
                $m['phoneImage'][0]['type'] = 'image';
            }

            $this->loadedData[$item->getId()] = array_merge($this->loadedData[$item->getId()],$m);

        }

        return $this->loadedData;
    }


    public function getMediaUrl($fileName)
    {
        $mediaUrl = $this->storeManager->getStore() ->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA).$fileName;
        return $mediaUrl;
    }

    public function getFileName($name){
        $info = basename($name);
        return $info;
    }

}