<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Magento\Catalog\Block;
use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\ResourceModel\Product\Collection;
use Magento\Catalog\Pricing\Price\FinalPrice;
use Magento\Framework\Pricing\Render;

class ListProduct extends \Magento\Catalog\Block\Product\AbstractProduct
{
    protected $_products;
    protected $_type = '';

    public function setProducts($products) {
        $this->_products = $products;
    }

    public function getProducts() {
        return $this->_products;
    }

    public function setType($type) {
        $this->_type = $type;
    }

    public function getType() {
        return $this->_type;
    }

    /**
     * Filter wysiwyg Content
     * @param $content
     * @return string
     * @throws \Exception
     */
    public function renderContent($content)
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $filterProvider = $objectManager->get('\Magento\Cms\Model\Template\FilterProvider');
        return $filterProvider->getBlockFilter()->filter($content);
    }

    public function getCategoryAds(&$start, $isMobile=false) {
        $itemCnt = $this->getRequest()->getParam('itemCnt') ?? 0;
        $start = $itemCnt + 1;
        $ads = array();
        if ('catalog_category_view' == $this->getRequest()->getFullActionName()) {
            $category = $this->_coreRegistry->registry('current_category');
            if ($category) {
                $type = ($isMobile ? 'mobile' : 'pc');
                $content = $category->getData('cat_list_ads_' . $type);
                if ($content) {
                    $content = str_replace('，', ',', $content);
                    $content = explode(PHP_EOL, $content);
                    foreach ($content as $row) {
                        $ad = explode(',', $row);
                        if (count($ad) < 3) {
                            continue;
                        }
                        $ads[trim($ad[0])] = array('image' => trim($this->renderContent($ad[1])), 'link' => trim($ad[2]));
                    }
                }
            }
        }
        return $ads;
    }

    public function isThreeColumns() {
        if ('catalog_category_view' == $this->getRequest()->getFullActionName()) {
            $category = $this->_coreRegistry->registry('current_category');
            if ($category) {
                return $category->getData('is_three_columns');
            }
        }
        return false;
    }
    public function getProductPrice(Product $product)
    {
        $priceRender = $this->getPriceRender();

        $price = '';
        if ($priceRender) {
            $price = $priceRender->render(
                FinalPrice::PRICE_CODE,
                $product,
                [
                    'include_container' => true,
                    'display_minimal_price' => true,
                    'zone' => Render::ZONE_ITEM_LIST,
                    'list_category_page' => true
                ]
            );
        }

        return $price;
    }
    protected function getPriceRender()
    {
        $priceRender = $this->getLayout()->getBlock('product.price.render.default');
        if (!$priceRender) {
            $priceRender = $this->getLayout()->createBlock(
                \Magento\Framework\Pricing\Render::class,
                'product.price.render.default',
                ['data' => ['price_render_handle' => 'catalog_product_prices']]
            );
        }
        return $priceRender;
    }
}
