define(['jquery'],function ($){

    $.fn.banner = function(options){
        var that = this;
        options = options || {};
        this._obj = {
            btn:options.btn===false ? false : true,
            list:options.list===false ? false : true,
            autoPlay:options.autoPlay===false ? false : true,
            delayTime:options.delayTime || 2000,
            moveTime:options.moveTime || 200,
            index:options.index || 0,
            iPrev:options.img.length-1,
            img:options.img || [],
            href:options.href || [],
        };
        this._obj.init = function(){
            var str = ``;
            for(var i=0;i<this.img.length;i++){
                str += `<a href="${this.href[i]}"><picture>
  <source media="(max-width: 768px)" srcset="${this.img[i][1]}" />
  <source media="(min-width: 769px)" srcset="${this.img[i][0]}" />
  <img src="${this.img[i][0]}" loading="lazy" class="top_banner" /></picture></a>`
            }
            that.html(`<div class="imgbox">${str}</div>`).css({
                "width":"100%",
                "height":"auto",
                position:"relative",
                overflow:"hidden"
            }).children(".imgbox").css({
                "width":"100%",

            }).children("a").css({
                position: "absolute",
                left:1920,
                top:0,
                "width":"100%",

            }).eq(0).css({
                left:0
            }).end().children("img").css({
                "width":"100%",
            });
        }
        this._obj.init();
        this._obj.leftClick=function () {
            if (that._obj.index ==0){
                that._obj.index = that._obj.img.length-1;
                that._obj.iPrev=0;
            }else{
                that._obj.index--;
                that._obj.iPrev=that._obj.index+1;
            }
            that._obj.btnMove(1);
        }
        this._obj.rightClick=function(){
            if (that._obj.index ==that._obj.img.length-1){
                that._obj.index = 0;
                that._obj.iPrev=that._obj.img.length-1;
            }else{
                that._obj.index++;
                that._obj.iPrev=that._obj.index-1;
            }
            that._obj.btnMove(-1);
        }
        if (this._obj.btn){
            $("<input type='button' id='left' value='<'>").css({
                left:0,
            }).appendTo(this).
            after($("<input type='button' id='right' value='>'>").css({
                right:0,
            })).parent()
                .children("input").css({
                position:"absolute",
                width:30,
                height:30,
                border:"none",
                background:"rgba(200,200,200,0.5)",
                borderRadius:"50%",
                color:"#ffffff"
            })
            this.on("click","#left",that._obj.leftClick)
            this.on("click","#right",that._obj.rightClick)
            this._obj.btnMove=function (type) {
                let imgs=that.children(".imgbox").children("a");
                imgs.eq(this.iPrev).css({
                    left:0
                }).stop().animate({
                    left:imgs.eq(0).width()*type
                },this.moveTime).end().eq(this.index).css({
                    left:-imgs.eq(0).width()*type
                }).stop().animate({
                    left:0
                },this.moveTime)
                if(!this.list) return;
                $(".list").children("li").css("background","rgba(200,200,200,0.6)")
                    .eq(this.index).css("background","#005caf")
            }
        }
        if (this._obj.list){
            let str="";
            for (var i=0;i<this._obj.img.length;i++){
                str+=`<li></li>`;
            }
            $("<ul class='list'>").html(str).appendTo(this).css({
                margin:0,
                padding:0,
                listStyle:"none",
                width:"100%",
                height:40,
                bottom:0,
                position:"absolute",
                display:"flex",
                justifyContent:"center",
                lineHeight:"40px",
                textAlign:"center"
            }).children("li").css({
                width:40,
                height:6,
                background:"rgba(200,200,200,0.6)",
                margin:"0 5px",
                textAlign: "center",
                cursor:"pointer"
            }).eq(0).css({
                background:"#005caf"
            }).end().click(function () {
                if ($(this).index()>that._obj.index){
                    that._obj.listMove($(this).index(),-1)
                }
                if ($(this).index()<that._obj.index){
                    that._obj.listMove($(this).index(),1)
                }
                that._obj.index = $(this).index();

            })
            this._obj.listMove=function (iNow,type) {
                let imgs=that.children(".imgbox").children("a");
                imgs.eq(this.index).css({
                    left:0
                }).stop().animate({
                    left:imgs.eq(0).width()*type
                },this.moveTime).end().eq(iNow).css({
                    left:-imgs.eq(0).width()*type
                }).stop().animate({
                    left:0
                },this.moveTime)

                $(".list").children("li").css("background","rgba(200,200,200,0.6)")
                    .eq(iNow).css("background","#005caf")
            }
        }
        if (this._obj.autoPlay){
            if (this._obj.img.length > 1){
                this._obj.t=setInterval(()=>{
                    this._obj.rightClick();
                },this._obj.delayTime);
                this.hover(function () {
                    clearInterval(that._obj.t)
                },function () {
                    that._obj.t=setInterval(()=>{
                        that._obj.rightClick();
                    },that._obj.delayTime);
                })
            }
        }
    }

 });