<?php

namespace Joshine\InstagramFeed\Block;

use Magento\Backend\Block\Template;
use Magento\Directory\Helper\Data as DirectoryHelper;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Json\Helper\Data as JsonHelper;
use Magento\Store\Model\ScopeInterface;

class ApiAddress extends Template
{
    const INSTAGRAM_API_BASE_URL = 'https://api.instagram.com';
    const INSTAGRAM_AUTH_URL = 'oauth/authorize';

    const REDIRECT_URL = 'admin/joshine_instagram/oauth/redirect';

    protected $_objectManager;

    public function __construct(
        Template\Context $context,
        array $data = [],
        \Magento\Framework\ObjectManagerInterface $objectManager
    )
    {
        $this->_objectManager = $objectManager;
        parent::__construct($context, $data);
    }

    public function getAppid()
    {
        return $this->_objectManager->get(ScopeConfigInterface::class)
            ->getValue(
                'joshine_instagram_feed/general/appid',
                ScopeInterface::SCOPE_STORE
            );
    }

    public function getAppSecret()
    {
        return $this->_objectManager->get(ScopeConfigInterface::class)
            ->getValue(
                'joshine_instagram_feed/general/app_secret',
                ScopeInterface::SCOPE_STORE
            );
    }

    public function redirectUri() :string
    {
        return $this->getBaseUrl().self::REDIRECT_URL;
    }

    public function authUrl() : string
    {
        return self::INSTAGRAM_API_BASE_URL.'/'
            .self::INSTAGRAM_AUTH_URL.
            "?client_id={$this->getAppid()}&redirect_uri={$this->redirectUri()}&scope=user_profile,user_media&response_type=code";
    }



}