/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'ko',
    'Magento_Checkout/js/model/checkout-data-resolver',
    'Magento_Checkout/js/model/quote'
], function (ko, checkoutDataResolver,quote) {
    'use strict';

    var shippingRates = ko.observableArray([]);
    var totals = quote.getTotals(),
        couponCode = ko.observable(null);

    if (totals()) {
        couponCode(totals()['coupon_code']);
    }

    return {
        isLoading: ko.observable(false),
        isAppliedCoupon: ko.observable(couponCode() != null),
        /**
         * Set shipping rates
         *
         * @param {*} ratesData
         */
        setShippingRates: function (ratesData) {
            shippingRates(ratesData);
            shippingRates.valueHasMutated();
            checkoutDataResolver.resolveShippingRates(ratesData);
        },

        /**
         * Get shipping rates
         *
         * @returns {*}
         */
        getShippingRates: function () {
            return shippingRates;
        }
    };
});
