<?php
namespace Joshine\Banner\Controller\Index;


use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Joshine\Banner\Model\BassFactory;


class Index extends \Magento\Framework\App\Action\Action{
    const ADMIN_RESOURCE =  'Joshine_Banner::index';

    protected $_pageFactory;
    protected $_bassFactory;




    public function __construct(Context $context,PageFactory $pageFactory, BassFactory $bassFactory)
    {
        $this->_bassFactory = $bassFactory;
        $this->_pageFactory = $pageFactory;
        return parent::__construct($context);
    }

    public function execute()
    {
        $resultPage = $this->_pageFactory->create();
        $resultPage->setActiveMenu('Joshine_Banner::index');
        $resultPage->getConfig()->getTitle()->prepend((__('Banner')));
        return $resultPage;
    }


}