<?php

namespace Joshine\CouponPusher\Block;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Template;
use Magento\Newsletter\Model\Subscriber;
use Magento\Store\Model\ScopeInterface;

class CouponSubscribeAlert extends \Magento\Framework\View\Element\Template
{
    protected $_template = 'Joshine_CouponPusher::coupon-subscribe-alert.phtml';

    protected $coupon;

    protected $_objectManager;

    protected $saleRule;

    protected $_rule;

    public function __construct(
        Template\Context $context,
        array $data = [],
        \Magento\SalesRule\Model\Coupon $coupon,
        \Magento\SalesRule\Model\Rule $saleRule,
        \Magento\Framework\ObjectManagerInterface $objectManager
    )
    {
        parent::__construct($context, $data);
        $this->coupon   = $coupon;
        $this->saleRule = $saleRule;
        $this->_objectManager = $objectManager;
    }

    public function getCoupon()
    {
        if (empty($this->_rule)) {
            $code = $this->_objectManager->get(ScopeConfigInterface::class)
                ->getValue(
                    'joshine_coupon_pusher/general/newsletter_coupon_code',
                    ScopeInterface::SCOPE_STORE
                );
            $ruleId =   $this->coupon->loadByCode($code)->getRuleId();
            $rule   = $this->saleRule->load($ruleId);
            $this->_rule = $rule;
        }
        return $this->_rule;
    }

    public function getCouponTitle()
    {
        return $this->_objectManager->get(ScopeConfigInterface::class)
            ->getValue(
                'joshine_coupon_pusher/general/newsletter_coupon_title',
                ScopeInterface::SCOPE_STORE
            );
    }

    public function getInformationTitle()
    {
        return $this->_objectManager->get(ScopeConfigInterface::class)
            ->getValue(
                'joshine_coupon_pusher/general/newsletter_information_title',
                ScopeInterface::SCOPE_STORE
            );
    }

    public function getInformationText()
    {
        return $this->_objectManager->get(ScopeConfigInterface::class)
            ->getValue(
                'joshine_coupon_pusher/general/newsletter_information_text',
                ScopeInterface::SCOPE_STORE
            );
    }

    public function getCouponDescription()
    {
        return $this->getCoupon()->getData('description');
    }
}