<?php
/**
 *
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\Checkout\Controller\Onepage;
use Aitoc\Smtp\Model\Config;
class Failure extends \Magento\Checkout\Controller\Onepage
{
    /**
     * @return \Magento\Framework\View\Result\Page|\Magento\Framework\Controller\Result\Redirect
     */
    public function execute()
    {
        $lastQuoteId = $this->getOnepage()->getCheckout()->getLastQuoteId();
        $lastOrderId = $this->getOnepage()->getCheckout()->getLastOrderId();
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        if(!$lastQuoteId && !$lastOrderId && isset($_REQUEST['order_sn']))
        {
            $order = $objectManager->create('Magento\Sales\Model\OrderFactory')->create()->loadByIncrementId($_REQUEST['order_sn']);
            $lastOrderId = $order->getId();
            $lastQuoteId = $order->getQuoteId();
        }
        $quote = $objectManager->create('Magento\Quote\Model\QuoteFactory')->create()->load($lastQuoteId);

        $quote->setReservedOrderId(null);
        $quote->setIsActive(true);
        $quote->removePayment();
        $quote->save();
        $objectManager->get(\Magento\Checkout\Model\Session::class)->replaceQuote($quote);
        $objectManager->get(\Magento\Checkout\Model\Session::class)->restoreQuote();

        //$this->cart->setQuote($quote);
        if ($lastQuoteId && $lastOrderId) {
            return $this->resultRedirectFactory->create()->setPath('checkout/cart');
        }

        return $this->resultPageFactory->create();
    }
}
