<?php


namespace Joshine\Category\Plugin\Catalog\Helper\Product;

use Magento\Catalog\Helper\Product\View as ProductViewHelper;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\Page;
use Magento\Framework\UrlInterface;
use Magento\TestFramework\Event\Magento;

class ViewPlugin
{
    /**
     * @var \Magento\Framework\Registry $coreRegistry,
     */
    private $coreRegistry;

    private $resultPage;

    private $urlInterface;


    public function __construct(Registry $coreRegistry, UrlInterface $urlInterface)
    {
        $this->coreRegistry = $coreRegistry;
        $this->urlInterface = $urlInterface;
    }

    public function aroundPrepareAndRender(
        ProductViewHelper $productViewHelper,
        callable $proceed,
        Page $resultPage,

                          $productId,
                          $controller,
                          $params = null
    ) {
        // collecting result page instance for future use
        $this->resultPage = $resultPage;

        // send the control to the original method
        $result = $proceed($resultPage, $productId, $controller, $params);

        // after meta title and description is generated, this will be executed

        // make sure the helper instance is correct
        if (!$result instanceof ProductViewHelper) {
            return $productViewHelper;
        }

        // collecting product information from the core registry
        $product = $this->coreRegistry->registry('product');

        // changing meta title and description as needed
        $this->alterMetaTitle($product);
        $this->alterMetaDescription($product);
        $this->alterMetaKeyword($product);

        return $result;
    }

    /**
     * Changing meta title of PDP; Allowing only 60 characters
     * @param $product
     */
    private function alterMetaTitle($product)
    {
        $pageConfig = $this->resultPage->getConfig();
        $title = $product->getMetaTitle();
        if (!$title){
            $url =  ltrim(parse_url($this->urlInterface->getBaseUrl())['host'],'www.');
            $pageConfig->getTitle()->set('$'.$product->getFinalPrice() . ' - ' .$product->getName() . ' Online at '.$url);
        }
    }

    /**
     * Changing meta description of PDP; Allowing only 60 characters
     * @param $product
     */
    private function alterMetaDescription($product)
    {
        $pageConfig = $this->resultPage->getConfig();
        $description = $product->getMetaDescription();

        if (!$description) {
            $url =  ltrim(parse_url($this->urlInterface->getBaseUrl())['host'],'www.');
            $pageConfig->setDescription('Buy ' . $product->getName() . ' Online at the Price of $' . $product->getFinalPrice() .' at '. $url . '.' . ' You Will Get the Best Service and Worldwide Free Shipping for Orders $69+.');
        }
    }

    /**
     * Changing meta keyword of PDP; Allowing only 60 characters
     * @param $product
     */
    private function alterMetaKeyword($product)
    {
        $pageConfig = $this->resultPage->getConfig();
        $keyWord = $product->getMetaKeyword();

        $ids = $product->getCategoryIds();
        if (!$keyWord) {
            $pageConfig->setKeywords($product->getName() . '. ' . $this->getCategoryName($ids) . '.');
        }
    }

    private function getCategoryName($ids){
        if (empty($ids) || !is_array($ids) || count($ids) < 2){
            return '';
        }
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $name = [];
        foreach ($ids as $val){
            $cat = $objectManager->create('Magento\Catalog\Model\Category')->load($val);
            $name[] = $cat->getName();
        }

        $diffArr = ['Root Catalog','Category'];
        $name = array_diff($name, $diffArr);

        return implode(',',$name);
    }
}
