<?php
namespace Joshine\Banner\Controller\Adminhtml\Index\FileUploader;

use Magento\Backend\App\Action;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\UrlInterface;
use \Magento\Framework\Controller\ResultFactory;
class Save extends Action
{
    const ADMIN_RESOURCE = "Joshine_Banner::index";
    const FILE_DIR = 'joshine/banner';

    protected $_fileUploaderFactory;

    protected $_filesystem;

    protected $mediaDirectory;

    protected $storeManager;

    protected $resultFactory;

    public function __construct(
        \Magento\Framework\Filesystem $filesystem,
        \Magento\MediaStorage\Model\File\UploaderFactory $fileUploaderFactory,
        Action\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        ResultFactory $resultFactory
    ) {
        $this->_filesystem = $filesystem;
        $this->_fileUploaderFactory = $fileUploaderFactory;
        $this->mediaDirectory = $filesystem->getDirectoryWrite(DirectoryList::MEDIA);
        $this->storeManager = $storeManager;
        $this->resultFactory = $resultFactory;
        parent::__construct($context);
    }

    public function execute()
    {
        try {
            $imageId = $this->_request->getParam('param_name');


            $uploader = $this->_fileUploaderFactory->create(['fileId' => $imageId]);

            $uploader->setAllowedExtensions(['jpg', 'jpeg', 'gif', 'png']);

            $uploader->setAllowRenameFiles(false);

            $uploader->setFilesDispersion(false);

            $path = $this->_filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath(self::FILE_DIR );

            $result = $uploader->save($path);

            $result['path'] = $this->getMediaPath($result['file']);
            $result['url'] = $this->getMediaUrl($result['file']);

            return $this->resultFactory->create(ResultFactory::TYPE_JSON)->setData($result);
        } catch (LocalizedException $e) {
           return ['error' => $e->getMessage(), 'errorcode' => $e->getCode()];
        } catch (\Throwable $e) {
            return ['error' => 'Something went wrong while saving the file(s).', 'errorcode' => 0];
        }

    }

    protected function getMediaPath($file){
        return '/' . $this->mediaDirectory->getRelativePath(self::FILE_DIR) . '/' . $this->prepareFile($file);
    }

    protected function getMediaUrl($file)
    {
        return $this->storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_MEDIA)
            . self::FILE_DIR . '/' . $this->prepareFile($file);
    }

    protected function prepareFile($file)
    {
        return ltrim(str_replace('\\', '/', $file), '/');
    }




}